---
title: Code of Conduct
description: Rules for involvement in the notion-enhancer community.
order: 4
---

# Code of Conduct

The notion-enhancer organisation and community are
purely for the purposes of involvement with and development
of the notion-enhancer project.

> At this point the notion-enhancer is an English-only space.

## Standards

Engaging with other members of the community should be a respectful,
harassment-free experience.

### Content

- Do not send disruptive, meaningless or repetitive messages (i.e. spam).
  If you would like to agree with something but do not have anything
  new to add, consider using an emoji reaction on the original message instead.

- Do not send unrelated, blatant or unsolicited advertisements.
  These are usually distracting and annoying.

- Do not use sexualised/inappropriate language or imagery. The community
  should be safe for anyone to join, and is not the place for that kind of content.

- Though some general discussion may occur, this community is primarily
  for discussion of the notion-enhancer. It is not the place for personal
  arguments on potentially divisive topics to take place.

### Conduct

- You may not spitefully/offensively/hatefully towards another person for any reason.
  This includes treating another person differently according to their
  age/race/gender/religion etc.

- Do not target other people with unwanted or repeated friend requests,
  mentions or direct messages. Respect people's personal space.

- Do not act in an otherwise illegal manner (e.g. sharing private information
  without explicit permission).

- Discuss constructively and attempt to consider what may appear best to
  others beyond yourself. Empathy and kindness can go a long way.

### Etiquette

- Use different repositories/channels appropriately according to their stated purposes,
  e.g. ask for help in #support instead of #general.

- Include context in your messages and get straight to the point - i.e. never say "can someone
  help me" and wait for a response. Instead, say something like "can someone help me do \_\_\_\_\_,
  I'm on \_\_\_\_\_ and have already tried \_\_\_\_\_" (see [nohello.net](https://nohello.net/)).

- Before asking a question, read other recently sent messages and type the question's keywords
  into the search bar - more often than not, someone else has already asked and received an answer.

## Enforcement

These rules are not up for debate and their enforcement and interpretation
are up to the notion-enhancer team. This may vary from case to case, depending
on the severity and context: e.g. breaking the etiquette guidelines may only result
in a warning or the message being ignored, while attacking another person may
lead to a temporary ban.
