#!/usr/bin/env python3

"""Script to visualize test cases by printing out the messages"""

import argparse
from importlib import resources
import json

from llm_rules import Message, data


def main():
    parser = argparse.ArgumentParser(description="Visualize test cases")
    parser.add_argument("--test_suite", default="redteam")
    parser.add_argument("--scenario", default=None)
    args = parser.parse_args()

    testsuite = getattr(data, args.test_suite)
    files = [
        f.name
        for f in resources.files(testsuite).iterdir()
        if f.name.endswith(".jsonl")
    ]
    files = sorted(files)

    if args.scenario is not None:
        files = [f for f in files if f.startswith(args.scenario)]
    for file in files:
        print("\n" + file)
        with resources.files(testsuite).joinpath(file).open() as f:
            for l in f.readlines():
                print("\n=========================================")
                testcase = json.loads(l.strip())
                print(testcase["params"])
                messages = Message.unserialize(testcase["messages"])
                for m in messages:
                    print(m)


if __name__ == "__main__":
    main()
