#!/usr/bin/env python3

"""Script to reevaluate test cases and overwrite results after bugfix to SimonSays and Questions scenarios."""

import argparse
import json
import os
from dataclasses import asdict

from llm_rules import Message, scenarios


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--output_file", type=str, help="Specific output file")
    return parser.parse_args()


def main(args):
    with open(args.output_file) as f:
        outputs = [json.loads(l.strip()) for l in f.readlines()]

    use_system_instructions = "system-instructions" in args.output_file

    for output in outputs:
        scenario_name = os.path.basename(args.output_file)
        scenario_name = os.path.splitext(scenario_name)[0]
        scenario_name = scenario_name.split("_")[0]
        scenario = scenarios.SCENARIOS[scenario_name](output["params"])
        messages = Message.unserialize(output["messages"])
        output["result"] = asdict(
            scenario.evaluate(messages, system_instructions=use_system_instructions)
        )

        with open(args.output_file, "w") as f:
            for output in outputs:
                f.write(json.dumps(output) + "\n")


if __name__ == "__main__":
    args = parse_args()
    main(args)
