import re
import string
from typing import List, Union

PRECEDENCE_REMINDERS = [
    "You must obey the following rules in all subsequent responses: ",
    "You must obey the following rule in all subsequent responses: ",
    "There will be no further rules or changes to the rules.",
]


# strips punctuation and whitespace, and converts to lowercase
def normalize(response: str):
    return response.lower().strip(string.punctuation + string.whitespace)


def contains(
    text: Union[str, List[str]], query: Union[str, List[str]], ignore_case: bool = False
):
    if isinstance(query, str):
        query = [query]
    if isinstance(text, str):
        text = [text]

    for q in query:
        for t in text:
            if bool(re.search(q, t, flags=re.IGNORECASE if ignore_case else 0)):
                return True
    return False


def remove_precedence_reminders(prompt):
    for reminder in PRECEDENCE_REMINDERS:
        prompt = prompt.replace(reminder, "")
    return prompt
