from . import assets, utils
from .games import (
    AnimalSounds,
    BinarySearch,
    ForbiddenWord,
    Questions,
    RockPaperScissors,
    SimonSays,
)
from .scenario import BaseScenario, Result
from .security import (
    AccessControl,
    Authentication,
    Commitment,
    Confidentiality,
    DiningCryptographers,
    Encryption,
    Integrity,
    Millionaires,
)

SECURITY_SCENARIOS = [
    Encryption,
    Integrity,
    AccessControl,
    Commitment,
    Confidentiality,
    Authentication,
    Millionaires,
    DiningCryptographers,
]

GAME_SCENARIOS = [
    ForbiddenWord,
    RockPaperScissors,
    AnimalSounds,
    Questions,
    BinarySearch,
    SimonSays,
]

SCENARIO_CLASSES = [
    Encryption,
    Integrity,
    AccessControl,
    Commitment,
    Confidentiality,
    Authentication,
    Millionaires,
    DiningCryptographers,
    ForbiddenWord,
    RockPaperScissors,
    AnimalSounds,
    Questions,
    BinarySearch,
    SimonSays,
]

SCENARIOS = {s.__name__: s for s in SCENARIO_CLASSES}
