from typing import List, Optional

from torch_llms import inference

from llm_rules import Message
from llm_rules.models.base import BaseModel


class TorchLLMsModel(BaseModel):
    supports_system_message = True

    def __init__(
        self,
        model: str,
        template_config: Optional[str] = None,
        temperature: float = 0.0,
        max_len: int = 4096,
        **kwargs,
    ):
        self.model = inference.LLM(
            ckpt_paths=[model],
            template_config=template_config,
            max_len=max_len,
            temperature=temperature,
        )

    def __call__(self, messages: List[Message]):
        messages = Message.serialize(messages)
        responses = self.model.generate(conversations=[messages], disable_tqdm=True)
        return responses
