from llm_rules.models.base import (
    PROMPTS,
    BaseModel,
    MockModel,
    build_prompt_fastchat,
    build_prompt_tokenizer,
    concat_stream,
    get_token_string,
    print_and_concat_stream,
)

PROVIDER_NAMES = ["mock"]

try:
    from llm_rules.models.transformers import TransformersModel
    PROVIDER_NAMES.append("transformers")
except ImportError:
    pass

try:
    from llm_rules.models.vllm import vLLMModel, vLLMServer
    PROVIDER_NAMES.append("vllm")
except ImportError:
    pass

try:
    from llm_rules.models.torch_llms import TorchLLMsModel
    PROVIDER_NAMES.append("torch_llms")
except ImportError:
    pass

try:
    from llm_rules.models.openai import OpenAIModel
    PROVIDER_NAMES.append("openai")
except ImportError:
    pass

try:
    from llm_rules.models.anthropic import (
        AnthropicModel,
        anthropic_call_with_retries,
    )
    PROVIDER_NAMES.append("anthropic")
except ImportError:
    pass

try:
    from llm_rules.models.google import (
        GoogleModel,
        google_call_with_retries,
    )
    PROVIDER_NAMES.append("google")
except ImportError:
    pass

try:
    from llm_rules.models.google_vertex import (
        GoogleVertexModel,
        google_vertex_call_with_retries,
    )
    PROVIDER_NAMES.append("google_vertex")
except ImportError:
    pass

try:
    from llm_rules.models.together import TogetherAIModel
except ImportError:
    pass


MODEL_BUILDERS = {
    "mock": MockModel,
    "anthropic": AnthropicModel,
    "google": GoogleModel,
    "google_vertex": GoogleVertexModel,
    "openai": OpenAIModel,
    "transformers": TransformersModel,
    "together": TogetherAIModel,
    "torch_llms": TorchLLMsModel,
    "vllm": vLLMModel,
}


def call_with_retries(model, messages):
    if isinstance(model, AnthropicModel):
        return anthropic_call_with_retries(model, messages)
    elif isinstance(model, GoogleModel):
        return google_call_with_retries(model, messages)
    elif isinstance(model, GoogleVertexModel):
        return google_vertex_call_with_retries(model, messages)
    else:
        # OpenAI python SDK automatically retries after v1.0
        return model(messages)
