#!/bin/bash

accelerate launch --config_file accelerate_config_4gpu.yaml finetune.py \
    --dataset_path "basic_like" \
    --conv_template_name "mistral" \
    --model_name_or_path "/data/norman_mu/models/Mistral-7B-Instruct-v0.1" \
    --learning_rate 2e-5 \
    --weight_decay 0 \
    --adam_beta1 0.9 \
    --adam_beta2 0.999 \
    --lr_scheduler_type "constant" \
    --bf16 True \
    --seed 42 \
    --output_dir "outputs/mistral1_bs=64_b2=0.999_wd=0" \
    --num_train_epochs 3 \
    --per_device_train_batch_size 2 \
    --gradient_accumulation_steps 8 \
    --do_eval False \
    --logging_steps 1 \
    --report_to "none" \
    --log_level "info"
