# Sulphur Point

Sulphur Point (Te Pari Taha o Te Awanui), located in Tauranga is a mixture of port and recreational marine activities.

It was reclaimed from the original harbour sandbar into extensive port and marina facilities over a period starting in 1970 ("European Timeline of Local Events", 2012) to mid 1990.

My personal history with Sulphur Point is long and varied. I've fished off the rocks as a teenager, set out from the marina on family launches countless times, launched my own boat, watched the storm clouds roll over the Kaimai ranges and waited in the cold for trains to rumble past with a tired four year old on my shoulders.

Sulphur Point is a past half forgotten, and an anchor in the present.

Spatially Sulphur Point is an ode to parking, be it car parks, containers or boats; the primary function of Sulphur Point is to park. It's an organisational utopia of rigid divisions, rows and columns, yellow and white paint, order fenced from order. An expression of human dominion over nature. It's a space to pass through, not to linger. It's colonising design ethos, stepped back and unnoticed, as all good design should be, shapes spatial navigation, demands usages, ensures flow.

Sulphur Point is divided roughly into thirds, one third into public and the other two thirds into private, corporate spaces. Boat ramps on one side, the port on the other, a 2.4m high rusting barb wire topped fence, neatly obscured by a row of landscaped vegetation in between.

Henri Lefebvre talks about the fetishisation of space in the service of state, where “space, already mystified and presumed innocent, is produced in capitalism in a way that makes it appear all the more devoid of social relationships” (Ballvé, 2011). To the casual user, Sulphur Point is simply a place to carry out pre ordained, spatially scripted tasks, a non-thing an empty, static plane upon which people act and events unfold (Ballvé, 2011). The refusal of opportunity for other interpretations, to be childlike with a sense of play is certainly an expedient expression of capitalist organisational dogma. Here space is organised around commerce and notions of work and compartmentalised play. Even when transiting the space to reach moored boats and be ‘free' on the ocean members of the public are elements in a capitalist spatial composition, which seeks to erase them from the site.

By journeying through the Sulphur Point environment without any of it's prescribed usages as an end goal I have sought to carve out my own personal perspective of and locality within the space. To ignore the ideological wayfinding, to observe, to blend personal histories and perceived materialities, is to subvert the ideology of the space.
When Sulphur Point's environment is viewed and experienced through the formal modernist compositional eye and thinking my institutionalised design training affords me, rigid organisational patterns begin to emerge. These patterns resonate most closely with Bauhaus functional units and an overarching spirit of the ‘machine'. This is a space which is predicated on moving machines, a technological utopia.
Walter Gropius, when starting the Bauahus sought to 'reconcile the artist and machine' (Snider, 2018) by using many of the same inherited techniques which are employed as planning constructs within the Sulphur Point spatial environment. The principles most evident to me, as observer are;

Simplicity  
Symmetry  
Angularity  
Abstraction  
Consistency  
Unity  
Organisation  
Economy  
Subtlety  
Continuity  
Regularity  
Sharpness  

Deriving a series of utilitarian compositional rules from the observed environment enabled a straightforward mapping from the physical and idealogical space of Sulphur Point to the conceptual and compositional space where a typeface might be drawn from. This design vernacular, allowed me to formulate a series of formal compositional rules which as (Lewis, 2018) states "in this design process, a typographic composer is provided the affordance to mobilise the created letterforms as meaning-making artifacts".

Historically the typography which embodies the expression of ideology closest to the spatial ideology of Sulphur Point is Bauhaus typography. A good example is Futura, whose geometric foundations are a reflection of Paul Renner sensing a zeitgeist. Futura is not strictly a Bauhaus typeface, as it makes concessions to legibility and utility which are absent from pure Bauhaus philosophic embodiments such as Herbert Bayer's "Universal". Irrespective of purity of approach, these typefaces prioritise geometry, regular form, legibility and as Martin Majoor (Majoor, 2018) suggests, an impression of construction.

### Formal Design Rules
The ideologies evident in the Sulphur Point environment are mediated through my personal compositional biases, design education, emotional attachments and personal design raison d'être, to create useful and used artefacts. This moderating heliocentric approach, where the user sits at the center of a design universe is coupled with Bauhaus functional units to drive a typographic composition which formally references the ideologies and spatial organisation of the Sulphur Point environment.

The typographically useful signifiers which most readily signify some of the Bauhaus functional units are the circle and the straight line. How these signifiers are rendered within the glyphs of the typeface signifies the ‘simplicity', ‘angularity', 'abstraction', 'economy' and 'sharpness' Bauhaus compositional units. How the typeface employs these signifiers and applies them as the in situ design language across the entire glyph set signifies the more organisational units such as 'unity',  'consistency', 'organisation', 'economy', 'subtlety', 'regularity' and 'symmetry'.

Following the basic structuralist approach above, I've contrasted some functional units into binary oppositions as a means of working backwards, and error checking the basic compositional approach underpinning the typeface. A sample of these units follows;

simplicity	complexity
regularity	irregularity
angularity	organic
abstraction	literal

On closer inspection these oppositions break down and blur into each other. But as expressions of the modernist perspective encapsulated by both the Bauhaus and the spatial planners of the Sulphur Point environment, these oppositions direct the visual language of the typeface into what it should and shouldn't be.

The Sulphur Point (typeface) is a product of Sulphur Point's spatiality, it's influence on me and my interactions within it. The typeface represents an the wrest of power from the space to create new artefacts and new spaces.

Documenting the Sulphur Point space involved photography, Dérive (drift), observation, wayfinding and drawing. Photography in particular was perceived as a noteworthy deviation from the spaces normative usage patterns. Which is ironic, considering how thoroughly surveilled the space is.

### Bibliography
Ballvé, T. (2011). _Lefebvre, Fetish, Critique | Territorial Masquerades._ Territorialmasquerades.net. Retrieved 19 March 2018, from http://territorialmasquerades.net/lefebvre-fetish-critique

Ballvé, T. (2011). _Spatiality & Power | Territorial Masquerades._ Territorialmasquerades.net. Retrieved 20 March 2018, from http://territorialmasquerades.net/spatiality-power/

_European Timeline of Local Events. (2012)._ Tauranga.kete.net.nz. Retrieved 19 March 2018, from http://tauranga.kete.net.nz/tauranga_local_history/topics/show/584-european-timeline-of-local-events

Lewis, H. (2018). _Contextualizing Place as Type: Creating an Auburn Typeface_ Xchanges.org. Retrieved 19 March 2018, from http://www.xchanges.org/contextualizing-place-as-type-creating

Majoor, M. (2018). _Typotheque: My Type Design Philosophy by Martin Majoor._ Typotheque.com. Retrieved 19 March 2018, from https://www.typotheque.com/articles/my_type_design_philosophy

OpenStreetMap contributors. (n.d.). _OpenStreetMap._ Retrieved from https://www.openstreetmap.org/#map= 16/-37.6650/176.1674

Snider, C. (2018). _Bauhaus : Philosophy._ Bauhaus.chrissnider.com. Retrieved 19 March 2018, from http://bauhaus.chrissnider.com/pages/philosophy.html
