#include <ESP8266WiFi.h>
#include <Adafruit_GFX.h>
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_NeoPixel.h>
#include <PubSubClient.h>
#include <ArduinoJson.h>

static const unsigned char nootropicdesign_logo [] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x37, 0xF0, 0x07, 0xF0, 0x0F, 0xE0, 0xFF, 0xE7, 0x7F, 0x01, 0xFE, 0x0D, 0xFE, 0x06, 0x0F, 0xF0,
    0x3C, 0x1E, 0x1C, 0x1C, 0x38, 0x38, 0x70, 0x07, 0xC1, 0xC7, 0x83, 0x8F, 0x83, 0x86, 0x3C, 0x3C,
    0x30, 0x06, 0x30, 0x06, 0x60, 0x0C, 0x30, 0x07, 0x00, 0x66, 0x01, 0x8E, 0x01, 0xC6, 0x30, 0x0C,
    0x30, 0x07, 0x30, 0x06, 0x60, 0x0C, 0x30, 0x07, 0x00, 0x66, 0x01, 0xCC, 0x00, 0xC6, 0x70, 0x00,
    0x30, 0x07, 0x30, 0x06, 0x60, 0x0C, 0x30, 0x07, 0x00, 0x06, 0x01, 0xCC, 0x00, 0xC6, 0x70, 0x00,
    0x30, 0x07, 0x30, 0x06, 0x60, 0x0C, 0x30, 0x07, 0x00, 0x06, 0x01, 0xCC, 0x00, 0xC6, 0x70, 0x00,
    0x30, 0x07, 0x30, 0x06, 0x60, 0x0C, 0x30, 0x37, 0x00, 0x06, 0x01, 0x8C, 0x00, 0xC6, 0x30, 0x0C,
    0x30, 0x07, 0x18, 0x0C, 0x30, 0x18, 0x38, 0x77, 0x00, 0x07, 0x03, 0x8F, 0x03, 0x86, 0x38, 0x1C,
    0x30, 0x07, 0x0F, 0xF8, 0x1F, 0xF0, 0x1F, 0xE7, 0x00, 0x01, 0xFF, 0x0D, 0xFF, 0x06, 0x1F, 0xF8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0xF6, 0x07, 0xF0, 0x1F, 0xF0, 0xC0, 0xFF, 0x63, 0xBF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3C, 0x1E, 0x1C, 0x1C, 0x70, 0x38, 0xC3, 0xC1, 0xE3, 0xE0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x06, 0x30, 0x0E, 0x60, 0x0C, 0xC3, 0x00, 0x63, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x06, 0x30, 0x06, 0x60, 0x00, 0xC7, 0x00, 0x63, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x06, 0x3F, 0xFE, 0x3F, 0xF8, 0xC7, 0x00, 0x63, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x70, 0x06, 0x30, 0x00, 0x00, 0x1C, 0xC7, 0x00, 0x63, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x06, 0x30, 0x06, 0x60, 0x0C, 0xC3, 0x00, 0x63, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x38, 0x0E, 0x38, 0x0C, 0x70, 0x1C, 0xC3, 0x80, 0xE3, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0xFE, 0x0F, 0xF8, 0x3F, 0xF0, 0xC0, 0xFF, 0xE3, 0x80, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

Adafruit_SSD1306 display(-1);

#define LED_PIN 15
Adafruit_NeoPixel led = Adafruit_NeoPixel(1, LED_PIN, NEO_RGB + NEO_KHZ800);

#define BUTTON_PIN 0
bool current = false;
bool last = false;

const char* ssid = "yourWIFInetwork";
const char* password = "yourWIFIpassword";
const char* mqtt_server = "yourMQTTserver";
int mqtt_port = 8883;
const char* mqtt_username = "yourMQTTuser";
const char* mqtt_password = "yourMQTTpassword";
const char* weatherTopic = "weather";

WiFiClientSecure espClient;
PubSubClient mqtt_client(espClient);
char data[128];

uint32_t ledColor = led.Color(0, 0, 255);

void blink(uint32_t color, int d);
void log(char *s);

int loopCount = 0;

// Receive MQTT message
void mqtt_callback(char* topic, byte* payload, unsigned int length) {
  Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  for (int i = 0; i < length; i++) {
    Serial.print((char)payload[i]);
  }
  Serial.println();
}

// Connect to MQTT broker
void mqtt_connect() {
  // Loop until we're reconnected
  while (!mqtt_client.connected()) {
    display.setCursor(0, 0);
    display.println("Connecting to");
    display.println("MQTT broker...");
    display.display(); delay(1);
    // Attempt to connect
    String mqtt_clientId = "iotExp-";
    mqtt_clientId += String(random(0xffff), HEX);
    if (mqtt_client.connect(mqtt_clientId.c_str(), mqtt_username, mqtt_password)) {
      Serial.println("connected");
      blink(led.Color(0, 255, 0), 20);
    } else {
      Serial.print("failed, rc=");
      Serial.println(mqtt_client.state());
      delay(2000);
    }
  }
}

void setup()   {       
  pinMode(BUTTON_PIN, INPUT); // digital input on BOOT button
  pinMode(2, OUTPUT); // ESP8266 LED
  digitalWrite(2, LOW);
  delay(200);
  digitalWrite(2, HIGH); 

  led.begin();
  led.show(); // Initialize all pixels to 'off'

  Serial.begin(115200);
  while (!Serial);

  display.begin(SSD1306_SWITCHCAPVCC, 0x3C, false);
  display.clearDisplay();
  display.setTextSize(1);
  display.drawBitmap(0, 0, nootropicdesign_logo, 128, 32, WHITE);
  display.display(); delay(1);

  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0, 36);

  display.println("Connecting to");
  display.print(ssid);
  display.display(); delay(1);
    
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(250);
    display.print(".");
    display.display(); delay(1);
  }
  display.println();
  display.println("connected");
  blink(led.Color(0, 255, 0), 200);

  mqtt_client.setServer(mqtt_server, mqtt_port);
  mqtt_client.setCallback(mqtt_callback);

  display.clearDisplay();
  display.display(); delay(1);
  mqtt_connect();

  display.setTextSize(2);
}



void loop() {
  if (!mqtt_client.connected()) {
    mqtt_connect();
  }
  mqtt_client.loop();


  Serial.setTimeout(250);
  String s = Serial.readString();
  if (s != NULL) {
    StaticJsonBuffer<200> jsonBuffer;
    JsonObject& json = jsonBuffer.parseObject(s);
    float temperature = json["temp"];
    float humidity = json["hum"];

    display.clearDisplay();
    display.setCursor(0, 0);
    display.println("TEMP: ");
    display.print(temperature);
    display.println(" F");
    display.println("HUM: ");
    display.print(humidity);
    display.println(" %");
    display.display(); delay(1);

    mqtt_client.publish(weatherTopic, s.c_str());

    blink(ledColor, 50);
  }
}


void blink(uint32_t color, int d) {
  led.setPixelColor(0, color);
  led.show();
  delay(d);
  led.clear();
  led.show();
}

void log(char *s) {
  if (display.getCursorY() > 58) {
    display.clearDisplay();
    display.setCursor(0, 0);
  }
  display.println(s);
  display.display(); delay(1);
}
