# LibertineSuper

[![][Fontbakery]](https://noirblancrouge.github.io/LibertineSuper/fontbakery/fontbakery-report.html)
[![][Universal]](https://noirblancrouge.github.io/LibertineSuper/fontbakery/fontbakery-report.html)
[![][GF Profile]](https://noirblancrouge.github.io/LibertineSuper/fontbakery/fontbakery-report.html)
[![][Outline Correctness]](https://noirblancrouge.github.io/LibertineSuper/fontbakery/fontbakery-report.html)
[![][Shaping]](https://noirblancrouge.github.io/LibertineSuper/fontbakery/fontbakery-report.html)

[Fontbakery]: https://img.shields.io/endpoint?url=https://noirblancrouge.github.io/LibertineSuper/fontbakery/overall.json
[GF Profile]: https://img.shields.io/endpoint?url=https://noirblancrouge.github.io/LibertineSuper/fontbakery/GoogleFonts.json
[Outline Correctness]: https://img.shields.io/endpoint?url=https://noirblancrouge.github.io/LibertineSuper/fontbakery/OutlineCorrectnessChecks.json
[Shaping]: https://img.shields.io/endpoint?url=https://noirblancrouge.github.io/LibertineSuper/fontbakery/ShapingChecks.json
[Universal]: https://img.shields.io/endpoint?url=https://noirblancrouge.github.io/LibertineSuper/fontbakery/Universal.json

![Cover](https://raw.githubusercontent.com/noirblancrouge/LibertineSuper/master/documentation/images/libertinesuper.jpg)

LibertineSuper comes in seven weights, and a variable version, including multilingual support and openType features.

LibertineSuper’s got these cool decorative lines in its default style, but if you’re more into easy reading, just hit up stylistic set 1 for a cleaner look. Fun fact: This font was born for the Libertine Supersport party’s vibe – so it knows how to party while looking sharp!

![Specimen](https://raw.githubusercontent.com/noirblancrouge/LibertineSuper/master/documentation/images/libertinesuper-variable.gif)

![Specimen](https://raw.githubusercontent.com/noirblancrouge/LibertineSuper/master/documentation/images/libertinesuper-charset.jpg)

## ChangeLog

When you make modifications, be sure to add a description of your changes,
following the format of the other entries, to the start of this section.

25 Aug 2023 (Bastien Sozeau)
- Add glyphs, add variable version, overall cleanup and redesign

10 Fev 2011 (Bastien Sozeau)
- Initital release. {LS}

## Bio

Bastien Sozeau is the founder of NoirBlancRouge, an independent type foundry based in Paris since 2019. Specializing in retail and custom typefaces, Bastien has crafted unique fonts for renowned brands such as Kipling, Christian Louboutin and The Olympic Museum. Beyond their commercial work, NoirBlancRouge has also been actively involved in designing free and open-source typefaces since 2013.

## Building

Fonts are built automatically by GitHub Actions - take a look in the "Actions" tab for the latest build.

If you want to build fonts manually on your own computer:

* `make build` will produce font files.
* `make test` will run [FontBakery](https://github.com/googlefonts/fontbakery)'s quality assurance tests.
* `make proof` will generate HTML proof files.

The proof files and QA tests are also available automatically via GitHub Actions - look at [noirblancrouge.github.io/LibertineSuper](https://noirblancrouge.github.io/LibertineSuper).

## License

Developed by [NoirBlancRouge Type Foundry](https://noirblancrouge.com) (Originally distributed by graphic design studio [Uplaod](https://uplaod.fr)) under the name "LS", LibertineSuper is open source and licensed under OFL, the SIL Open Font License allows the licensed fonts to be used, studied, modified and redistributed freely as long as they are not sold by themselves.

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is available with a FAQ at
https://scripts.sil.org/OFL

## Repository Layout

This font repository structure is inspired by [Unified Font Repository v0.3](https://github.com/unified-font-repository/Unified-Font-Repository), modified for the Google Fonts workflow.
