# ![Laravel.vim](https://noahfrederick.com/pi/vim-laravel-888by140-40a40a.png)

Vim support for [Laravel/Lumen][laravel] projects.

[![Release][release]](https://github.com/noahfrederick/vim-laravel/releases)
[![Build Status][buildimg]](https://travis-ci.org/noahfrederick/vim-laravel)

> :warning: This is a prerelease version, which may introduce breaking changes.

[laravel]:  https://laravel.com/
[release]:  https://img.shields.io/github/v/release/noahfrederick/vim-laravel.svg
[buildimg]: https://img.shields.io/travis/noahfrederick/vim-laravel/master.svg

## Features

* The `:Artisan` command wraps `!php artisan` with intelligent completion.
* Automatically load new files generated by `:Artisan make:*` commands into a buffer.
* Navigation commands such as `:Econtroller`, `:Eroutes`, `:Etest` and [many more][wiki-navigation].
* Enhanced `gf` command works on class names, template names, config and translation keys.
* Complete view/route names in insert mode.
* Use `:Console` to fire up a REPL (`artisan tinker`).
* Use `:Start` to serve the app locally (`artisan serve`).

[wiki-navigation]: https://github.com/noahfrederick/vim-laravel/wiki/Navigation-Commands

## Installation

Laravel.vim depends on a few other plug-ins for optional features, including
[composer.vim][vim-composer], [dispatch.vim][dispatch], and
[projectionist.vim][projectionist]:

	Plug 'tpope/vim-dispatch'             "| Optional
	Plug 'tpope/vim-projectionist'        "|
	Plug 'noahfrederick/vim-composer'     "|
	Plug 'noahfrederick/vim-laravel'

See the [full list of requirements and integrations][wiki-requirements].

[wiki-requirements]: https://github.com/noahfrederick/vim-laravel/wiki/Requirements

## Credits and License

Thanks to Tim Pope for [rails.vim][rails] on which Laravel.vim is modeled.

Copyright © Noah Frederick. Distributed under the same terms as Vim itself.
See `:help license`.

[vim-composer]: https://github.com/noahfrederick/vim-composer
[projectionist]: https://github.com/tpope/vim-projectionist
[dispatch]: https://github.com/tpope/vim-dispatch
[rails]: https://github.com/tpope/vim-rails
