import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface TopicConfig extends TerraformModuleUserConfig {
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The services to create subscriptions for
    */
    readonly subscriberServices: any;
    /**
    * The name of the topic
    */
    readonly topicName: string;
}
/**
* Defines an Topic based on a Terraform module
*
* Source at ./.nitric/modules/topic
*/
export declare class Topic extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: TopicConfig);
    get stackId(): string;
    set stackId(value: string);
    get subscriberServices(): any;
    set subscriberServices(value: any);
    get topicName(): string;
    set topicName(value: string);
    get topicNameOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
