import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface StackConfig extends TerraformModuleUserConfig {
    /**
    * The location to deploy the stack
    */
    readonly location: string;
    /**
    * The name of the nitric stack
    */
    readonly stackName: string;
}
/**
* Defines an Stack based on a Terraform module
*
* Source at ./.nitric/modules/stack
*/
export declare class Stack extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: StackConfig);
    get location(): string;
    set location(value: string);
    get stackName(): string;
    set stackName(value: string);
    get baseComputeRoleOutput(): string;
    get containerRegistryUriOutput(): string;
    get iamRolesOutput(): string;
    get stackIdOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
