import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface TopicConfig extends TerraformModuleUserConfig {
    /**
    * A list of lambda ARNs to subscribe to the topic
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly lambdaSubscribers: {
        [key: string]: string;
    };
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The name of the bucket. This must be globally unique.
    */
    readonly topicName: string;
}
/**
* Defines an Topic based on a Terraform module
*
* Source at ./.nitric/modules/topic
*/
export declare class Topic extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: TopicConfig);
    get lambdaSubscribers(): {
        [key: string]: string;
    };
    set lambdaSubscribers(value: {
        [key: string]: string;
    });
    get stackId(): string;
    set stackId(value: string);
    get topicName(): string;
    set topicName(value: string);
    get sfnArnOutput(): string;
    get topicArnOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
