import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ServiceConfig extends TerraformModuleUserConfig {
    /**
    * Environment variables to set on the lambda function
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly environment: {
        [key: string]: string;
    };
    /**
    * The docker image to deploy
    */
    readonly image: string;
    /**
    * The amount of memory to allocate to the lambda function
    * 128
    */
    readonly memory?: number;
    /**
    * The ID of the Google Cloud project where the service is created.
    */
    readonly projectId: string;
    /**
    * The region the service is being deployed to
    */
    readonly region: string;
    /**
    * The name of the service
    */
    readonly serviceName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    */
    readonly testing: string;
    /**
    * The timeout for the lambda function
    * 10
    */
    readonly timeout?: number;
}
/**
* Defines an Service based on a Terraform module
*
* Source at ./.nitric/modules/service
*/
export declare class Service extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ServiceConfig);
    get environment(): {
        [key: string]: string;
    };
    set environment(value: {
        [key: string]: string;
    });
    get image(): string;
    set image(value: string);
    get memory(): number | undefined;
    set memory(value: number | undefined);
    get projectId(): string;
    set projectId(value: string);
    get region(): string;
    set region(value: string);
    get serviceName(): string;
    set serviceName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get testing(): string;
    set testing(value: string);
    get timeout(): number | undefined;
    set timeout(value: number | undefined);
    get invokerServiceAccountEmailOutput(): string;
    get serviceAccountEmailOutput(): string;
    get serviceEndpointOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
