import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface PolicyConfig extends TerraformModuleUserConfig {
    /**
    * actions to allow
    */
    readonly actions: string[];
    /**
    * principals (roles) to apply the policies to
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly principals: {
        [key: string]: string;
    };
    /**
    * resources to apply the policies to
    */
    readonly resources: string[];
}
/**
* Defines an Policy based on a Terraform module
*
* Source at ./.nitric/modules/policy
*/
export declare class Policy extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: PolicyConfig);
    get actions(): string[];
    set actions(value: string[]);
    get principals(): {
        [key: string]: string;
    };
    set principals(value: {
        [key: string]: string;
    });
    get resources(): string[];
    set resources(value: string[]);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
