import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface BucketConfig extends TerraformModuleUserConfig {
    /**
    * The location where the bucket and its contents are stored.
    */
    readonly bucketLocation: string;
    /**
    * The name of the bucket. This must be globally unique.
    */
    readonly bucketName: string;
    /**
    * The notification target configurations
    */
    readonly notificationTargets: any;
    /**
    * The ID of the Google Cloud project where the bucket is created.
    */
    readonly projectId: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The class of storage used to store the bucket's contents. This can be STANDARD, NEARLINE, COLDLINE, ARCHIVE, or MULTI_REGIONAL.
    * STANDARD
    */
    readonly storageClass?: string;
}
/**
* Defines an Bucket based on a Terraform module
*
* Source at ./.nitric/modules/bucket
*/
export declare class Bucket extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: BucketConfig);
    get bucketLocation(): string;
    set bucketLocation(value: string);
    get bucketName(): string;
    set bucketName(value: string);
    get notificationTargets(): any;
    set notificationTargets(value: any);
    get projectId(): string;
    set projectId(value: string);
    get stackId(): string;
    set stackId(value: string);
    get storageClass(): string | undefined;
    set storageClass(value: string | undefined);
    get bucketLocationOutput(): string;
    get bucketNameOutput(): string;
    get bucketStorageClassOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
