import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface BucketConfig extends TerraformModuleUserConfig {
    /**
    * The name of the bucket. This must be globally unique.
    */
    readonly bucketName: string;
    /**
    * The notification target configurations
    */
    readonly notificationTargets: any;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
}
/**
* Defines an Bucket based on a Terraform module
*
* Source at ./.nitric/modules/bucket
*/
export declare class Bucket extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: BucketConfig);
    get bucketName(): string;
    set bucketName(value: string);
    get notificationTargets(): any;
    set notificationTargets(value: any);
    get stackId(): string;
    set stackId(value: string);
    get bucketArnOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
