import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface WebsocketConfig extends TerraformModuleUserConfig {
    /**
    * The ARN of the lambda to send websocket connection events to
    */
    readonly lambdaConnectTarget: string;
    /**
    * The ARN of the lambda to send websocket disconnection events to
    */
    readonly lambdaDisconnectTarget: string;
    /**
    * The ARN of the lambda to send websocket disconnection events to
    */
    readonly lambdaMessageTarget: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The name of the websocket.
    */
    readonly websocketName: string;
}
/**
* Defines an Websocket based on a Terraform module
*
* Source at ./.nitric/modules/websocket
*/
export declare class Websocket extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: WebsocketConfig);
    get lambdaConnectTarget(): string;
    set lambdaConnectTarget(value: string);
    get lambdaDisconnectTarget(): string;
    set lambdaDisconnectTarget(value: string);
    get lambdaMessageTarget(): string;
    set lambdaMessageTarget(value: string);
    get stackId(): string;
    set stackId(value: string);
    get websocketName(): string;
    set websocketName(value: string);
    get websocketArnOutput(): string;
    get websocketExecArnOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
