// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.4
// source: nitric/proto/websockets/v1/websockets.proto

package websocketspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// WebsocketClient is the client API for Websocket service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebsocketClient interface {
	// Send a messages to a websocket
	SendMessage(ctx context.Context, in *WebsocketSendRequest, opts ...grpc.CallOption) (*WebsocketSendResponse, error)
	// Close a websocket connection
	// This can be used to force a client to disconnect
	CloseConnection(ctx context.Context, in *WebsocketCloseConnectionRequest, opts ...grpc.CallOption) (*WebsocketCloseConnectionResponse, error)
	// Retrieve details about an API
	SocketDetails(ctx context.Context, in *WebsocketDetailsRequest, opts ...grpc.CallOption) (*WebsocketDetailsResponse, error)
}

type websocketClient struct {
	cc grpc.ClientConnInterface
}

func NewWebsocketClient(cc grpc.ClientConnInterface) WebsocketClient {
	return &websocketClient{cc}
}

func (c *websocketClient) SendMessage(ctx context.Context, in *WebsocketSendRequest, opts ...grpc.CallOption) (*WebsocketSendResponse, error) {
	out := new(WebsocketSendResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.websockets.v1.Websocket/SendMessage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *websocketClient) CloseConnection(ctx context.Context, in *WebsocketCloseConnectionRequest, opts ...grpc.CallOption) (*WebsocketCloseConnectionResponse, error) {
	out := new(WebsocketCloseConnectionResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.websockets.v1.Websocket/CloseConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *websocketClient) SocketDetails(ctx context.Context, in *WebsocketDetailsRequest, opts ...grpc.CallOption) (*WebsocketDetailsResponse, error) {
	out := new(WebsocketDetailsResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.websockets.v1.Websocket/SocketDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebsocketServer is the server API for Websocket service.
// All implementations should embed UnimplementedWebsocketServer
// for forward compatibility
type WebsocketServer interface {
	// Send a messages to a websocket
	SendMessage(context.Context, *WebsocketSendRequest) (*WebsocketSendResponse, error)
	// Close a websocket connection
	// This can be used to force a client to disconnect
	CloseConnection(context.Context, *WebsocketCloseConnectionRequest) (*WebsocketCloseConnectionResponse, error)
	// Retrieve details about an API
	SocketDetails(context.Context, *WebsocketDetailsRequest) (*WebsocketDetailsResponse, error)
}

// UnimplementedWebsocketServer should be embedded to have forward compatible implementations.
type UnimplementedWebsocketServer struct {
}

func (UnimplementedWebsocketServer) SendMessage(context.Context, *WebsocketSendRequest) (*WebsocketSendResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendMessage not implemented")
}
func (UnimplementedWebsocketServer) CloseConnection(context.Context, *WebsocketCloseConnectionRequest) (*WebsocketCloseConnectionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseConnection not implemented")
}
func (UnimplementedWebsocketServer) SocketDetails(context.Context, *WebsocketDetailsRequest) (*WebsocketDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SocketDetails not implemented")
}

// UnsafeWebsocketServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebsocketServer will
// result in compilation errors.
type UnsafeWebsocketServer interface {
	mustEmbedUnimplementedWebsocketServer()
}

func RegisterWebsocketServer(s grpc.ServiceRegistrar, srv WebsocketServer) {
	s.RegisterService(&Websocket_ServiceDesc, srv)
}

func _Websocket_SendMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WebsocketSendRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebsocketServer).SendMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.websockets.v1.Websocket/SendMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebsocketServer).SendMessage(ctx, req.(*WebsocketSendRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Websocket_CloseConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WebsocketCloseConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebsocketServer).CloseConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.websockets.v1.Websocket/CloseConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebsocketServer).CloseConnection(ctx, req.(*WebsocketCloseConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Websocket_SocketDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WebsocketDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebsocketServer).SocketDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.websockets.v1.Websocket/SocketDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebsocketServer).SocketDetails(ctx, req.(*WebsocketDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Websocket_ServiceDesc is the grpc.ServiceDesc for Websocket service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Websocket_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "nitric.proto.websockets.v1.Websocket",
	HandlerType: (*WebsocketServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SendMessage",
			Handler:    _Websocket_SendMessage_Handler,
		},
		{
			MethodName: "CloseConnection",
			Handler:    _Websocket_CloseConnection_Handler,
		},
		{
			MethodName: "SocketDetails",
			Handler:    _Websocket_SocketDetails_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "nitric/proto/websockets/v1/websockets.proto",
}

// WebsocketHandlerClient is the client API for WebsocketHandler service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WebsocketHandlerClient interface {
	// Handle incoming websocket events
	HandleEvents(ctx context.Context, opts ...grpc.CallOption) (WebsocketHandler_HandleEventsClient, error)
}

type websocketHandlerClient struct {
	cc grpc.ClientConnInterface
}

func NewWebsocketHandlerClient(cc grpc.ClientConnInterface) WebsocketHandlerClient {
	return &websocketHandlerClient{cc}
}

func (c *websocketHandlerClient) HandleEvents(ctx context.Context, opts ...grpc.CallOption) (WebsocketHandler_HandleEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &WebsocketHandler_ServiceDesc.Streams[0], "/nitric.proto.websockets.v1.WebsocketHandler/HandleEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &websocketHandlerHandleEventsClient{stream}
	return x, nil
}

type WebsocketHandler_HandleEventsClient interface {
	Send(*ClientMessage) error
	Recv() (*ServerMessage, error)
	grpc.ClientStream
}

type websocketHandlerHandleEventsClient struct {
	grpc.ClientStream
}

func (x *websocketHandlerHandleEventsClient) Send(m *ClientMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *websocketHandlerHandleEventsClient) Recv() (*ServerMessage, error) {
	m := new(ServerMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// WebsocketHandlerServer is the server API for WebsocketHandler service.
// All implementations should embed UnimplementedWebsocketHandlerServer
// for forward compatibility
type WebsocketHandlerServer interface {
	// Handle incoming websocket events
	HandleEvents(WebsocketHandler_HandleEventsServer) error
}

// UnimplementedWebsocketHandlerServer should be embedded to have forward compatible implementations.
type UnimplementedWebsocketHandlerServer struct {
}

func (UnimplementedWebsocketHandlerServer) HandleEvents(WebsocketHandler_HandleEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method HandleEvents not implemented")
}

// UnsafeWebsocketHandlerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WebsocketHandlerServer will
// result in compilation errors.
type UnsafeWebsocketHandlerServer interface {
	mustEmbedUnimplementedWebsocketHandlerServer()
}

func RegisterWebsocketHandlerServer(s grpc.ServiceRegistrar, srv WebsocketHandlerServer) {
	s.RegisterService(&WebsocketHandler_ServiceDesc, srv)
}

func _WebsocketHandler_HandleEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WebsocketHandlerServer).HandleEvents(&websocketHandlerHandleEventsServer{stream})
}

type WebsocketHandler_HandleEventsServer interface {
	Send(*ServerMessage) error
	Recv() (*ClientMessage, error)
	grpc.ServerStream
}

type websocketHandlerHandleEventsServer struct {
	grpc.ServerStream
}

func (x *websocketHandlerHandleEventsServer) Send(m *ServerMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *websocketHandlerHandleEventsServer) Recv() (*ClientMessage, error) {
	m := new(ClientMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// WebsocketHandler_ServiceDesc is the grpc.ServiceDesc for WebsocketHandler service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var WebsocketHandler_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "nitric.proto.websockets.v1.WebsocketHandler",
	HandlerType: (*WebsocketHandlerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "HandleEvents",
			Handler:       _WebsocketHandler_HandleEvents_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "nitric/proto/websockets/v1/websockets.proto",
}
