// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.4
// source: nitric/proto/storage/v1/storage.proto

package storagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// StorageClient is the client API for Storage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageClient interface {
	// Retrieve an item from a bucket
	Read(ctx context.Context, in *StorageReadRequest, opts ...grpc.CallOption) (*StorageReadResponse, error)
	// Store an item to a bucket
	Write(ctx context.Context, in *StorageWriteRequest, opts ...grpc.CallOption) (*StorageWriteResponse, error)
	// Delete an item from a bucket
	Delete(ctx context.Context, in *StorageDeleteRequest, opts ...grpc.CallOption) (*StorageDeleteResponse, error)
	// Generate a pre-signed URL for direct operations on an item
	PreSignUrl(ctx context.Context, in *StoragePreSignUrlRequest, opts ...grpc.CallOption) (*StoragePreSignUrlResponse, error)
	// List blobs currently in the bucket
	ListBlobs(ctx context.Context, in *StorageListBlobsRequest, opts ...grpc.CallOption) (*StorageListBlobsResponse, error)
	// Determine is an object exists in a bucket
	Exists(ctx context.Context, in *StorageExistsRequest, opts ...grpc.CallOption) (*StorageExistsResponse, error)
}

type storageClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageClient(cc grpc.ClientConnInterface) StorageClient {
	return &storageClient{cc}
}

func (c *storageClient) Read(ctx context.Context, in *StorageReadRequest, opts ...grpc.CallOption) (*StorageReadResponse, error) {
	out := new(StorageReadResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/Read", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Write(ctx context.Context, in *StorageWriteRequest, opts ...grpc.CallOption) (*StorageWriteResponse, error) {
	out := new(StorageWriteResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/Write", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Delete(ctx context.Context, in *StorageDeleteRequest, opts ...grpc.CallOption) (*StorageDeleteResponse, error) {
	out := new(StorageDeleteResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/Delete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) PreSignUrl(ctx context.Context, in *StoragePreSignUrlRequest, opts ...grpc.CallOption) (*StoragePreSignUrlResponse, error) {
	out := new(StoragePreSignUrlResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/PreSignUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) ListBlobs(ctx context.Context, in *StorageListBlobsRequest, opts ...grpc.CallOption) (*StorageListBlobsResponse, error) {
	out := new(StorageListBlobsResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/ListBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageClient) Exists(ctx context.Context, in *StorageExistsRequest, opts ...grpc.CallOption) (*StorageExistsResponse, error) {
	out := new(StorageExistsResponse)
	err := c.cc.Invoke(ctx, "/nitric.proto.storage.v1.Storage/Exists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageServer is the server API for Storage service.
// All implementations should embed UnimplementedStorageServer
// for forward compatibility
type StorageServer interface {
	// Retrieve an item from a bucket
	Read(context.Context, *StorageReadRequest) (*StorageReadResponse, error)
	// Store an item to a bucket
	Write(context.Context, *StorageWriteRequest) (*StorageWriteResponse, error)
	// Delete an item from a bucket
	Delete(context.Context, *StorageDeleteRequest) (*StorageDeleteResponse, error)
	// Generate a pre-signed URL for direct operations on an item
	PreSignUrl(context.Context, *StoragePreSignUrlRequest) (*StoragePreSignUrlResponse, error)
	// List blobs currently in the bucket
	ListBlobs(context.Context, *StorageListBlobsRequest) (*StorageListBlobsResponse, error)
	// Determine is an object exists in a bucket
	Exists(context.Context, *StorageExistsRequest) (*StorageExistsResponse, error)
}

// UnimplementedStorageServer should be embedded to have forward compatible implementations.
type UnimplementedStorageServer struct {
}

func (UnimplementedStorageServer) Read(context.Context, *StorageReadRequest) (*StorageReadResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Read not implemented")
}
func (UnimplementedStorageServer) Write(context.Context, *StorageWriteRequest) (*StorageWriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Write not implemented")
}
func (UnimplementedStorageServer) Delete(context.Context, *StorageDeleteRequest) (*StorageDeleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedStorageServer) PreSignUrl(context.Context, *StoragePreSignUrlRequest) (*StoragePreSignUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PreSignUrl not implemented")
}
func (UnimplementedStorageServer) ListBlobs(context.Context, *StorageListBlobsRequest) (*StorageListBlobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBlobs not implemented")
}
func (UnimplementedStorageServer) Exists(context.Context, *StorageExistsRequest) (*StorageExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exists not implemented")
}

// UnsafeStorageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageServer will
// result in compilation errors.
type UnsafeStorageServer interface {
	mustEmbedUnimplementedStorageServer()
}

func RegisterStorageServer(s grpc.ServiceRegistrar, srv StorageServer) {
	s.RegisterService(&Storage_ServiceDesc, srv)
}

func _Storage_Read_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageReadRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Read(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/Read",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Read(ctx, req.(*StorageReadRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Write_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageWriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Write(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/Write",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Write(ctx, req.(*StorageWriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageDeleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Delete(ctx, req.(*StorageDeleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_PreSignUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StoragePreSignUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).PreSignUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/PreSignUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).PreSignUrl(ctx, req.(*StoragePreSignUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_ListBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageListBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).ListBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/ListBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).ListBlobs(ctx, req.(*StorageListBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Storage_Exists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StorageExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageServer).Exists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/nitric.proto.storage.v1.Storage/Exists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageServer).Exists(ctx, req.(*StorageExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Storage_ServiceDesc is the grpc.ServiceDesc for Storage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Storage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "nitric.proto.storage.v1.Storage",
	HandlerType: (*StorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Read",
			Handler:    _Storage_Read_Handler,
		},
		{
			MethodName: "Write",
			Handler:    _Storage_Write_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Storage_Delete_Handler,
		},
		{
			MethodName: "PreSignUrl",
			Handler:    _Storage_PreSignUrl_Handler,
		},
		{
			MethodName: "ListBlobs",
			Handler:    _Storage_ListBlobs_Handler,
		},
		{
			MethodName: "Exists",
			Handler:    _Storage_Exists_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "nitric/proto/storage/v1/storage.proto",
}

// StorageListenerClient is the client API for StorageListener service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type StorageListenerClient interface {
	// Listen for changes on a bucket
	Listen(ctx context.Context, opts ...grpc.CallOption) (StorageListener_ListenClient, error)
}

type storageListenerClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageListenerClient(cc grpc.ClientConnInterface) StorageListenerClient {
	return &storageListenerClient{cc}
}

func (c *storageListenerClient) Listen(ctx context.Context, opts ...grpc.CallOption) (StorageListener_ListenClient, error) {
	stream, err := c.cc.NewStream(ctx, &StorageListener_ServiceDesc.Streams[0], "/nitric.proto.storage.v1.StorageListener/Listen", opts...)
	if err != nil {
		return nil, err
	}
	x := &storageListenerListenClient{stream}
	return x, nil
}

type StorageListener_ListenClient interface {
	Send(*ClientMessage) error
	Recv() (*ServerMessage, error)
	grpc.ClientStream
}

type storageListenerListenClient struct {
	grpc.ClientStream
}

func (x *storageListenerListenClient) Send(m *ClientMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *storageListenerListenClient) Recv() (*ServerMessage, error) {
	m := new(ServerMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StorageListenerServer is the server API for StorageListener service.
// All implementations should embed UnimplementedStorageListenerServer
// for forward compatibility
type StorageListenerServer interface {
	// Listen for changes on a bucket
	Listen(StorageListener_ListenServer) error
}

// UnimplementedStorageListenerServer should be embedded to have forward compatible implementations.
type UnimplementedStorageListenerServer struct {
}

func (UnimplementedStorageListenerServer) Listen(StorageListener_ListenServer) error {
	return status.Errorf(codes.Unimplemented, "method Listen not implemented")
}

// UnsafeStorageListenerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StorageListenerServer will
// result in compilation errors.
type UnsafeStorageListenerServer interface {
	mustEmbedUnimplementedStorageListenerServer()
}

func RegisterStorageListenerServer(s grpc.ServiceRegistrar, srv StorageListenerServer) {
	s.RegisterService(&StorageListener_ServiceDesc, srv)
}

func _StorageListener_Listen_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StorageListenerServer).Listen(&storageListenerListenServer{stream})
}

type StorageListener_ListenServer interface {
	Send(*ServerMessage) error
	Recv() (*ClientMessage, error)
	grpc.ServerStream
}

type storageListenerListenServer struct {
	grpc.ServerStream
}

func (x *storageListenerListenServer) Send(m *ServerMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *storageListenerListenServer) Recv() (*ClientMessage, error) {
	m := new(ClientMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StorageListener_ServiceDesc is the grpc.ServiceDesc for StorageListener service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StorageListener_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "nitric.proto.storage.v1.StorageListener",
	HandlerType: (*StorageListenerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Listen",
			Handler:       _StorageListener_Listen_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "nitric/proto/storage/v1/storage.proto",
}
