import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ServiceConfig extends TerraformModuleUserConfig {
    /**
    * The base URI for the artifact registry repository the push this services image to
    */
    readonly artifactRegistryRepository: string;
    /**
    * The base compute role to use for the service
    */
    readonly baseComputeRole: string;
    /**
    * The number of concurrent requests the CloudRun service can handle
    * 80
    */
    readonly containerConcurrency?: number;
    /**
    * The amount of cpus to allocate to the CloudRun service
    * 1
    */
    readonly cpus?: number;
    /**
    * Environment variables to set on the lambda function
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly environment: {
        [key: string]: string;
    };
    /**
    * The amount of gpus to allocate to the CloudRun service
    */
    readonly gpus?: number;
    /**
    * The docker image to deploy
    */
    readonly image: string;
    /**
    * The maximum number of instances to run
    * 10
    */
    readonly maxInstances?: number;
    /**
    * The amount of memory to allocate to the CloudRun service in MB
    * 512
    */
    readonly memoryMb?: number;
    /**
    * The minimum number of instances to run
    */
    readonly minInstances?: number;
    /**
    * The ID of the Google Cloud project where the service is created.
    */
    readonly projectId: string;
    /**
    * The region the service is being deployed to
    */
    readonly region: string;
    /**
    * The name of the service
    */
    readonly serviceName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The timeout for the CloudRun service in seconds
    * 10
    */
    readonly timeoutSeconds?: number;
}
/**
* Defines an Service based on a Terraform module
*
* Source at ./.nitric/modules/service
*/
export declare class Service extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ServiceConfig);
    get artifactRegistryRepository(): string;
    set artifactRegistryRepository(value: string);
    get baseComputeRole(): string;
    set baseComputeRole(value: string);
    get containerConcurrency(): number | undefined;
    set containerConcurrency(value: number | undefined);
    get cpus(): number | undefined;
    set cpus(value: number | undefined);
    get environment(): {
        [key: string]: string;
    };
    set environment(value: {
        [key: string]: string;
    });
    get gpus(): number | undefined;
    set gpus(value: number | undefined);
    get image(): string;
    set image(value: string);
    get maxInstances(): number | undefined;
    set maxInstances(value: number | undefined);
    get memoryMb(): number | undefined;
    set memoryMb(value: number | undefined);
    get minInstances(): number | undefined;
    set minInstances(value: number | undefined);
    get projectId(): string;
    set projectId(value: string);
    get region(): string;
    set region(value: string);
    get serviceName(): string;
    set serviceName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get timeoutSeconds(): number | undefined;
    set timeoutSeconds(value: number | undefined);
    get eventTokenOutput(): string;
    get invokerServiceAccountEmailOutput(): string;
    get serviceAccountEmailOutput(): string;
    get serviceEndpointOutput(): string;
    get serviceNameOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
