import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface HttpProxyConfig extends TerraformModuleUserConfig {
    /**
    * The name of the HTTP proxy gateway
    */
    readonly name: string;
    /**
    * The ID of the stack
    */
    readonly stackId: string;
    /**
    * The name or arn of the lambda function being proxied
    */
    readonly targetLambdaFunction: string;
}
/**
* Defines an HttpProxy based on a Terraform module
*
* Source at ./.nitric/modules/http_proxy
*/
export declare class HttpProxy extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: HttpProxyConfig);
    get name(): string;
    set name(value: string);
    get stackId(): string;
    set stackId(value: string);
    get targetLambdaFunction(): string;
    set targetLambdaFunction(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
