import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ScheduleConfig extends TerraformModuleUserConfig {
    /**
    * The schedule expression
    */
    readonly scheduleExpression: string;
    /**
    * The name of the schedule
    */
    readonly scheduleName: string;
    /**
    * The timezone for the schedule
    */
    readonly scheduleTimezone: string;
    /**
    * The token to authenticate with the target service
    */
    readonly serviceToken: string;
    /**
    * The email of the target service invoker
    */
    readonly targetServiceInvokerEmail: string;
    /**
    * The URL of the target service
    */
    readonly targetServiceUrl: string;
}
/**
* Defines an Schedule based on a Terraform module
*
* Source at ./.nitric/modules/schedule
*/
export declare class Schedule extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ScheduleConfig);
    get scheduleExpression(): string;
    set scheduleExpression(value: string);
    get scheduleName(): string;
    set scheduleName(value: string);
    get scheduleTimezone(): string;
    set scheduleTimezone(value: string);
    get serviceToken(): string;
    set serviceToken(value: string);
    get targetServiceInvokerEmail(): string;
    set targetServiceInvokerEmail(value: string);
    get targetServiceUrl(): string;
    set targetServiceUrl(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
