import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ApiConfig extends TerraformModuleUserConfig {
    /**
    * The name of the API Gateway
    */
    readonly name: string;
    /**
    * The OpenAPI spec as a JSON string
    */
    readonly openapiSpec: string;
    /**
    * The ID of the stack
    */
    readonly stackId: string;
    /**
    * The map of target service names
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly targetServices: {
        [key: string]: string;
    };
}
/**
* Defines an Api based on a Terraform module
*
* Source at ./.nitric/modules/api
*/
export declare class Api extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ApiConfig);
    get name(): string;
    set name(value: string);
    get openapiSpec(): string;
    set openapiSpec(value: string);
    get stackId(): string;
    set stackId(value: string);
    get targetServices(): {
        [key: string]: string;
    };
    set targetServices(value: {
        [key: string]: string;
    });
    get endpointOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
