import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface VpcConfig extends TerraformModuleUserConfig {
    /**
    * The CIDR block for the VPC
    * 10.0.0.0/16
    */
    readonly cidrBlock?: string;
    /**
    * Private Subnet CIDR values
    * 10.0.4.0/24
    * 10.0.5.0/24
    * 10.0.6.0/24
    */
    readonly privateSubnetCidrs?: string[];
    /**
    * Public Subnet CIDR values
    * 10.0.1.0/24
    * 10.0.2.0/24
    * 10.0.3.0/24
    */
    readonly publicSubnetCidrs?: string[];
}
/**
* Defines an Vpc based on a Terraform module
*
* Source at ./.nitric/modules/vpc
*/
export declare class Vpc extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config?: VpcConfig);
    get cidrBlock(): string | undefined;
    set cidrBlock(value: string | undefined);
    get privateSubnetCidrs(): string[] | undefined;
    set privateSubnetCidrs(value: string[] | undefined);
    get publicSubnetCidrs(): string[] | undefined;
    set publicSubnetCidrs(value: string[] | undefined);
    get privateSubnetIdsOutput(): string;
    get publicSubnetIdsOutput(): string;
    get vpcIdOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
