import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface SqlConfig extends TerraformModuleUserConfig {
    /**
    * The region of the codebuild project
    */
    readonly codebuildRegion: string;
    /**
    * The arn of the codebuild role
    */
    readonly codebuildRoleArn: string;
    /**
    * The name of the create database codebuild project
    */
    readonly createDatabaseProjectName: string;
    /**
    * The name of the database to create
    */
    readonly dbName: string;
    /**
    * The URI of the docker image to use for the codebuild project
    */
    readonly imageUri: string;
    /**
    * The command to run to migrate the database
    */
    readonly migrateCommand: string;
    /**
    * The endpoint of the RDS cluster to connect to
    */
    readonly rdsClusterEndpoint: string;
    /**
    * The password to connect to the RDS cluster
    */
    readonly rdsClusterPassword: string;
    /**
    * The username to connect to the RDS cluster
    */
    readonly rdsClusterUsername: string;
    /**
    * The security group ids to use for the codebuild project
    */
    readonly securityGroupIds: string[];
    /**
    * The subnet ids to use for the codebuild project
    */
    readonly subnetIds: string[];
    /**
    * The vpc id to use for the codebuild project
    */
    readonly vpcId: string;
    /**
    * The working directory for the codebuild project
    */
    readonly workDir: string;
}
/**
* Defines an Sql based on a Terraform module
*
* Source at ./.nitric/modules/sql
*/
export declare class Sql extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: SqlConfig);
    get codebuildRegion(): string;
    set codebuildRegion(value: string);
    get codebuildRoleArn(): string;
    set codebuildRoleArn(value: string);
    get createDatabaseProjectName(): string;
    set createDatabaseProjectName(value: string);
    get dbName(): string;
    set dbName(value: string);
    get imageUri(): string;
    set imageUri(value: string);
    get migrateCommand(): string;
    set migrateCommand(value: string);
    get rdsClusterEndpoint(): string;
    set rdsClusterEndpoint(value: string);
    get rdsClusterPassword(): string;
    set rdsClusterPassword(value: string);
    get rdsClusterUsername(): string;
    set rdsClusterUsername(value: string);
    get securityGroupIds(): string[];
    set securityGroupIds(value: string[]);
    get subnetIds(): string[];
    set subnetIds(value: string[]);
    get vpcId(): string;
    set vpcId(value: string);
    get workDir(): string;
    set workDir(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
