"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Rds = void 0;
// generated by cdktf get
// ./.nitric/modules/rds
const cdktf_1 = require("cdktf");
/**
* Defines an Rds based on a Terraform module
*
* Source at ./.nitric/modules/rds
*/
class Rds extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/rds',
        });
        this.inputs = {};
        this.maxCapacity = config.maxCapacity;
        this.minCapacity = config.minCapacity;
        this.privateSubnetIds = config.privateSubnetIds;
        this.stackId = config.stackId;
        this.vpcId = config.vpcId;
    }
    get maxCapacity() {
        return this.inputs['max_capacity'];
    }
    set maxCapacity(value) {
        this.inputs['max_capacity'] = value;
    }
    get minCapacity() {
        return this.inputs['min_capacity'];
    }
    set minCapacity(value) {
        this.inputs['min_capacity'] = value;
    }
    get privateSubnetIds() {
        return this.inputs['private_subnet_ids'];
    }
    set privateSubnetIds(value) {
        this.inputs['private_subnet_ids'] = value;
    }
    get stackId() {
        return this.inputs['stack_id'];
    }
    set stackId(value) {
        this.inputs['stack_id'] = value;
    }
    get vpcId() {
        return this.inputs['vpc_id'];
    }
    set vpcId(value) {
        this.inputs['vpc_id'] = value;
    }
    get clusterEndpointOutput() {
        return this.getString('cluster_endpoint');
    }
    get clusterPasswordOutput() {
        return this.getString('cluster_password');
    }
    get clusterUsernameOutput() {
        return this.getString('cluster_username');
    }
    get codebuildRoleArnOutput() {
        return this.getString('codebuild_role_arn');
    }
    get createDatabaseProjectNameOutput() {
        return this.getString('create_database_project_name');
    }
    get securityGroupIdOutput() {
        return this.getString('security_group_id');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Rds = Rds;
//# sourceMappingURL=data:application/json;base64,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