import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ApiConfig extends TerraformModuleUserConfig {
    /**
    * The domains to associate with the API Gateway
    */
    readonly domains: string[];
    /**
    * The name of the API Gateway
    */
    readonly name: string;
    /**
    * Open API spec
    */
    readonly spec: string;
    /**
    * The ID of the stack
    */
    readonly stackId: string;
    /**
    * The names of the target lambda functions
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly targetLambdaFunctions: {
        [key: string]: string;
    };
}
/**
* Defines an Api based on a Terraform module
*
* Source at ./.nitric/modules/api
*/
export declare class Api extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ApiConfig);
    get domains(): string[];
    set domains(value: string[]);
    get name(): string;
    set name(value: string);
    get spec(): string;
    set spec(value: string);
    get stackId(): string;
    set stackId(value: string);
    get targetLambdaFunctions(): {
        [key: string]: string;
    };
    set targetLambdaFunctions(value: {
        [key: string]: string;
    });
    get endpointOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
