"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
// generated by cdktf get
// ./.nitric/modules/service
const cdktf_1 = require("cdktf");
/**
* Defines an Service based on a Terraform module
*
* Source at ./.nitric/modules/service
*/
class Service extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/service',
        });
        this.inputs = {};
        this.artifactRegistryRepository = config.artifactRegistryRepository;
        this.baseComputeRole = config.baseComputeRole;
        this.containerConcurrency = config.containerConcurrency;
        this.cpus = config.cpus;
        this.environment = config.environment;
        this.gpus = config.gpus;
        this.image = config.image;
        this.maxInstances = config.maxInstances;
        this.memoryMb = config.memoryMb;
        this.minInstances = config.minInstances;
        this.projectId = config.projectId;
        this.region = config.region;
        this.serviceName = config.serviceName;
        this.stackId = config.stackId;
        this.timeoutSeconds = config.timeoutSeconds;
    }
    get artifactRegistryRepository() {
        return this.inputs['artifact_registry_repository'];
    }
    set artifactRegistryRepository(value) {
        this.inputs['artifact_registry_repository'] = value;
    }
    get baseComputeRole() {
        return this.inputs['base_compute_role'];
    }
    set baseComputeRole(value) {
        this.inputs['base_compute_role'] = value;
    }
    get containerConcurrency() {
        return this.inputs['container_concurrency'];
    }
    set containerConcurrency(value) {
        this.inputs['container_concurrency'] = value;
    }
    get cpus() {
        return this.inputs['cpus'];
    }
    set cpus(value) {
        this.inputs['cpus'] = value;
    }
    get environment() {
        return this.inputs['environment'];
    }
    set environment(value) {
        this.inputs['environment'] = value;
    }
    get gpus() {
        return this.inputs['gpus'];
    }
    set gpus(value) {
        this.inputs['gpus'] = value;
    }
    get image() {
        return this.inputs['image'];
    }
    set image(value) {
        this.inputs['image'] = value;
    }
    get maxInstances() {
        return this.inputs['max_instances'];
    }
    set maxInstances(value) {
        this.inputs['max_instances'] = value;
    }
    get memoryMb() {
        return this.inputs['memory_mb'];
    }
    set memoryMb(value) {
        this.inputs['memory_mb'] = value;
    }
    get minInstances() {
        return this.inputs['min_instances'];
    }
    set minInstances(value) {
        this.inputs['min_instances'] = value;
    }
    get projectId() {
        return this.inputs['project_id'];
    }
    set projectId(value) {
        this.inputs['project_id'] = value;
    }
    get region() {
        return this.inputs['region'];
    }
    set region(value) {
        this.inputs['region'] = value;
    }
    get serviceName() {
        return this.inputs['service_name'];
    }
    set serviceName(value) {
        this.inputs['service_name'] = value;
    }
    get stackId() {
        return this.inputs['stack_id'];
    }
    set stackId(value) {
        this.inputs['stack_id'] = value;
    }
    get timeoutSeconds() {
        return this.inputs['timeout_seconds'];
    }
    set timeoutSeconds(value) {
        this.inputs['timeout_seconds'] = value;
    }
    get eventTokenOutput() {
        return this.getString('event_token');
    }
    get invokerServiceAccountEmailOutput() {
        return this.getString('invoker_service_account_email');
    }
    get serviceAccountEmailOutput() {
        return this.getString('service_account_email');
    }
    get serviceEndpointOutput() {
        return this.getString('service_endpoint');
    }
    get serviceNameOutput() {
        return this.getString('service_name');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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