import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface SecretConfig extends TerraformModuleUserConfig {
    /**
    * The name of the secret.
    */
    readonly secretName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
}
/**
* Defines an Secret based on a Terraform module
*
* Source at ./.nitric/modules/secret
*/
export declare class Secret extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: SecretConfig);
    get secretName(): string;
    set secretName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get nameOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
