"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = void 0;
// generated by cdktf get
// ./.nitric/modules/service
const cdktf_1 = require("cdktf");
/**
* Defines an Service based on a Terraform module
*
* Source at ./.nitric/modules/service
*/
class Service extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/service',
        });
        this.inputs = {};
        this.environment = config.environment;
        this.ephemeralStorage = config.ephemeralStorage;
        this.image = config.image;
        this.memory = config.memory;
        this.securityGroupIds = config.securityGroupIds;
        this.serviceName = config.serviceName;
        this.stackId = config.stackId;
        this.subnetIds = config.subnetIds;
        this.timeout = config.timeout;
    }
    get environment() {
        return this.inputs['environment'];
    }
    set environment(value) {
        this.inputs['environment'] = value;
    }
    get ephemeralStorage() {
        return this.inputs['ephemeral_storage'];
    }
    set ephemeralStorage(value) {
        this.inputs['ephemeral_storage'] = value;
    }
    get image() {
        return this.inputs['image'];
    }
    set image(value) {
        this.inputs['image'] = value;
    }
    get memory() {
        return this.inputs['memory'];
    }
    set memory(value) {
        this.inputs['memory'] = value;
    }
    get securityGroupIds() {
        return this.inputs['security_group_ids'];
    }
    set securityGroupIds(value) {
        this.inputs['security_group_ids'] = value;
    }
    get serviceName() {
        return this.inputs['service_name'];
    }
    set serviceName(value) {
        this.inputs['service_name'] = value;
    }
    get stackId() {
        return this.inputs['stack_id'];
    }
    set stackId(value) {
        this.inputs['stack_id'] = value;
    }
    get subnetIds() {
        return this.inputs['subnet_ids'];
    }
    set subnetIds(value) {
        this.inputs['subnet_ids'] = value;
    }
    get timeout() {
        return this.inputs['timeout'];
    }
    set timeout(value) {
        this.inputs['timeout'] = value;
    }
    get invokeArnOutput() {
        return this.getString('invoke_arn');
    }
    get lambdaArnOutput() {
        return this.getString('lambda_arn');
    }
    get lambdaFunctionNameOutput() {
        return this.getString('lambda_function_name');
    }
    get roleArnOutput() {
        return this.getString('role_arn');
    }
    get roleNameOutput() {
        return this.getString('role_name');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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