import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface KeyvalueConfig extends TerraformModuleUserConfig {
    /**
    * The name of the kv store.
    */
    readonly kvstoreName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
}
/**
* Defines an Keyvalue based on a Terraform module
*
* Source at ./.nitric/modules/keyvalue
*/
export declare class Keyvalue extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: KeyvalueConfig);
    get kvstoreName(): string;
    set kvstoreName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get kvArnOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
