import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ScheduleConfig extends TerraformModuleUserConfig {
    /**
    * The schedule expression
    */
    readonly scheduleExpression: string;
    /**
    * The name of the schedule
    */
    readonly scheduleName: string;
    /**
    * The timezone for the schedule
    */
    readonly scheduleTimezone: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The ARN of the target lambda function
    */
    readonly targetLambdaArn: string;
}
/**
* Defines an Schedule based on a Terraform module
*
* Source at ./.nitric/modules/schedule
*/
export declare class Schedule extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ScheduleConfig);
    get scheduleExpression(): string;
    set scheduleExpression(value: string);
    get scheduleName(): string;
    set scheduleName(value: string);
    get scheduleTimezone(): string;
    set scheduleTimezone(value: string);
    get stackId(): string;
    set stackId(value: string);
    get targetLambdaArn(): string;
    set targetLambdaArn(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
