"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stack = void 0;
// generated by cdktf get
// ./.nitric/modules/stack
const cdktf_1 = require("cdktf");
/**
* Defines an Stack based on a Terraform module
*
* Source at ./.nitric/modules/stack
*/
class Stack extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/stack',
        });
        this.inputs = {};
        this.location = config.location;
        this.stackName = config.stackName;
    }
    get location() {
        return this.inputs['location'];
    }
    set location(value) {
        this.inputs['location'] = value;
    }
    get stackName() {
        return this.inputs['stack_name'];
    }
    set stackName(value) {
        this.inputs['stack_name'] = value;
    }
    get baseComputeRoleOutput() {
        return this.getString('base_compute_role');
    }
    get containerRegistryUriOutput() {
        return this.getString('container_registry_uri');
    }
    get iamRolesOutput() {
        return this.getString('iam_roles');
    }
    get stackIdOutput() {
        return this.getString('stack_id');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Stack = Stack;
//# sourceMappingURL=data:application/json;base64,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