"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Websocket = void 0;
// generated by cdktf get
// ./.nitric/modules/websocket
const cdktf_1 = require("cdktf");
/**
* Defines an Websocket based on a Terraform module
*
* Source at ./.nitric/modules/websocket
*/
class Websocket extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/websocket',
        });
        this.inputs = {};
        this.lambdaConnectTarget = config.lambdaConnectTarget;
        this.lambdaDisconnectTarget = config.lambdaDisconnectTarget;
        this.lambdaMessageTarget = config.lambdaMessageTarget;
        this.stackId = config.stackId;
        this.websocketName = config.websocketName;
    }
    get lambdaConnectTarget() {
        return this.inputs['lambda_connect_target'];
    }
    set lambdaConnectTarget(value) {
        this.inputs['lambda_connect_target'] = value;
    }
    get lambdaDisconnectTarget() {
        return this.inputs['lambda_disconnect_target'];
    }
    set lambdaDisconnectTarget(value) {
        this.inputs['lambda_disconnect_target'] = value;
    }
    get lambdaMessageTarget() {
        return this.inputs['lambda_message_target'];
    }
    set lambdaMessageTarget(value) {
        this.inputs['lambda_message_target'] = value;
    }
    get stackId() {
        return this.inputs['stack_id'];
    }
    set stackId(value) {
        this.inputs['stack_id'] = value;
    }
    get websocketName() {
        return this.inputs['websocket_name'];
    }
    set websocketName(value) {
        this.inputs['websocket_name'] = value;
    }
    get websocketArnOutput() {
        return this.getString('websocket_arn');
    }
    get websocketExecArnOutput() {
        return this.getString('websocket_exec_arn');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Websocket = Websocket;
//# sourceMappingURL=data:application/json;base64,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