import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface ServiceConfig extends TerraformModuleUserConfig {
    /**
    * Environment variables to set on the lambda function
    * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
    */
    readonly environment: {
        [key: string]: string;
    };
    /**
    * The amount of ephemeral storage to allocate to the lambda function in MB
    * 512
    */
    readonly ephemeralStorage?: number;
    /**
    * The docker image to deploy
    */
    readonly image: string;
    /**
    * The amount of memory to allocate to the lambda function in MB
    * 128
    */
    readonly memory?: number;
    /**
    * The security group ids to use for the aws lambda function
    *
    */
    readonly securityGroupIds?: string[];
    /**
    * The name of the service
    */
    readonly serviceName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
    /**
    * The subnet ids to use for the aws lambda function
    *
    */
    readonly subnetIds?: string[];
    /**
    * The timeout for the lambda function in seconds
    * 15
    */
    readonly timeout?: number;
}
/**
* Defines an Service based on a Terraform module
*
* Source at ./.nitric/modules/service
*/
export declare class Service extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: ServiceConfig);
    get environment(): {
        [key: string]: string;
    };
    set environment(value: {
        [key: string]: string;
    });
    get ephemeralStorage(): number | undefined;
    set ephemeralStorage(value: number | undefined);
    get image(): string;
    set image(value: string);
    get memory(): number | undefined;
    set memory(value: number | undefined);
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    get serviceName(): string;
    set serviceName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    get timeout(): number | undefined;
    set timeout(value: number | undefined);
    get invokeArnOutput(): string;
    get lambdaArnOutput(): string;
    get lambdaFunctionNameOutput(): string;
    get roleArnOutput(): string;
    get roleNameOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
