import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface RdsConfig extends TerraformModuleUserConfig {
    /**
    * the maximum capacity of the RDS cluster
    */
    readonly maxCapacity: number;
    /**
    * the minimum capacity of the RDS cluster
    */
    readonly minCapacity: number;
    /**
    * private subnets to assign to the RDS cluster
    */
    readonly privateSubnetIds: string[];
    /**
    * The nitric stack ID
    */
    readonly stackId: string;
    /**
    * the VPC to assign to the RDS cluster
    */
    readonly vpcId: string;
}
/**
* Defines an Rds based on a Terraform module
*
* Source at ./.nitric/modules/rds
*/
export declare class Rds extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: RdsConfig);
    get maxCapacity(): number;
    set maxCapacity(value: number);
    get minCapacity(): number;
    set minCapacity(value: number);
    get privateSubnetIds(): string[];
    set privateSubnetIds(value: string[]);
    get stackId(): string;
    set stackId(value: string);
    get vpcId(): string;
    set vpcId(value: string);
    get clusterEndpointOutput(): string;
    get clusterPasswordOutput(): string;
    get clusterUsernameOutput(): string;
    get codebuildRoleArnOutput(): string;
    get createDatabaseProjectNameOutput(): string;
    get securityGroupIdOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
