import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface QueueConfig extends TerraformModuleUserConfig {
    /**
    * The name of the queue
    */
    readonly queueName: string;
    /**
    * The ID of the Nitric stack
    */
    readonly stackId: string;
}
/**
* Defines an Queue based on a Terraform module
*
* Source at ./.nitric/modules/queue
*/
export declare class Queue extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: QueueConfig);
    get queueName(): string;
    set queueName(value: string);
    get stackId(): string;
    set stackId(value: string);
    get queueArnOutput(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
