"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bucket = void 0;
// generated by cdktf get
// ./.nitric/modules/bucket
const cdktf_1 = require("cdktf");
/**
* Defines an Bucket based on a Terraform module
*
* Source at ./.nitric/modules/bucket
*/
class Bucket extends cdktf_1.TerraformModule {
    constructor(scope, id, config) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/bucket',
        });
        this.inputs = {};
        this.bucketLocation = config.bucketLocation;
        this.bucketName = config.bucketName;
        this.notificationTargets = config.notificationTargets;
        this.projectId = config.projectId;
        this.stackId = config.stackId;
        this.storageClass = config.storageClass;
    }
    get bucketLocation() {
        return this.inputs['bucket_location'];
    }
    set bucketLocation(value) {
        this.inputs['bucket_location'] = value;
    }
    get bucketName() {
        return this.inputs['bucket_name'];
    }
    set bucketName(value) {
        this.inputs['bucket_name'] = value;
    }
    get notificationTargets() {
        return this.inputs['notification_targets'];
    }
    set notificationTargets(value) {
        this.inputs['notification_targets'] = value;
    }
    get projectId() {
        return this.inputs['project_id'];
    }
    set projectId(value) {
        this.inputs['project_id'] = value;
    }
    get stackId() {
        return this.inputs['stack_id'];
    }
    set stackId(value) {
        this.inputs['stack_id'] = value;
    }
    get storageClass() {
        return this.inputs['storage_class'];
    }
    set storageClass(value) {
        this.inputs['storage_class'] = value;
    }
    get bucketLocationOutput() {
        return this.getString('bucket_location');
    }
    get bucketNameOutput() {
        return this.getString('bucket_name');
    }
    get bucketStorageClassOutput() {
        return this.getString('bucket_storage_class');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Bucket = Bucket;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnVja2V0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlCQUF5QjtBQUN6QiwyQkFBMkI7QUFDM0IsaUNBQW1FO0FBNkJuRTs7OztFQUlFO0FBQ0YsTUFBYSxNQUFPLFNBQVEsdUJBQWU7SUFFekMsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBb0I7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixHQUFHLE1BQU07WUFDVCxNQUFNLEVBQUUsMEJBQTBCO1NBQ25DLENBQUMsQ0FBQztRQUxZLFdBQU0sR0FBNEIsRUFBRyxDQUFBO1FBTXBELElBQUksQ0FBQyxjQUFjLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM1QyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDcEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztRQUN0RCxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbEMsSUFBSSxDQUFDLE9BQU8sR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQzlCLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBVyxDQUFDO0lBQ2xELENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCLENBQUMsR0FBRyxLQUFLLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFXLENBQUM7SUFDOUMsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBUSxDQUFDO0lBQ3BELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQVU7UUFDdkMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQVcsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUNwQyxDQUFDO0lBQ0QsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQVcsQ0FBQztJQUMzQyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ0QsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQyxlQUFlLENBQXVCLENBQUM7SUFDNUQsQ0FBQztJQUNELElBQVcsWUFBWSxDQUFDLEtBQXlCO1FBQy9DLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7SUFDRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsaUJBQWlCLENBQUMsQ0FBQTtJQUMxQyxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQyxDQUFBO0lBQ3RDLENBQUM7SUFDRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsc0JBQXNCLENBQUMsQ0FBQTtJQUMvQyxDQUFDO0lBQ1Msb0JBQW9CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBQ1MsdUJBQXVCO1FBQy9CLE9BQU8sTUFBTSxDQUFDLFdBQVcsQ0FDdkIsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO2FBQ3hCLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxFQUFFLENBQUMsR0FBRyxLQUFLLFNBQVMsQ0FBQzthQUN0QyxHQUFHLENBQUMsQ0FBQyxDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsRUFBRSxFQUFFO1lBQ2xCLE9BQU87Z0JBQ0wsR0FBRztnQkFDSDtvQkFDRSxLQUFLLEVBQUUsR0FBRztvQkFDVixJQUFJLEVBQUUsS0FBSztpQkFDWjthQUNGLENBQUM7UUFDSixDQUFDLENBQUMsQ0FDTCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBN0VELHdCQTZFQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGdlbmVyYXRlZCBieSBjZGt0ZiBnZXRcbi8vIC4vLm5pdHJpYy9tb2R1bGVzL2J1Y2tldFxuaW1wb3J0IHsgVGVycmFmb3JtTW9kdWxlLCBUZXJyYWZvcm1Nb2R1bGVVc2VyQ29uZmlnIH0gZnJvbSAnY2RrdGYnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5leHBvcnQgaW50ZXJmYWNlIEJ1Y2tldENvbmZpZyBleHRlbmRzIFRlcnJhZm9ybU1vZHVsZVVzZXJDb25maWcge1xuICAvKipcbiAgKiBUaGUgbG9jYXRpb24gd2hlcmUgdGhlIGJ1Y2tldCBhbmQgaXRzIGNvbnRlbnRzIGFyZSBzdG9yZWQuXG4gICovXG4gIHJlYWRvbmx5IGJ1Y2tldExvY2F0aW9uOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSBidWNrZXQuIFRoaXMgbXVzdCBiZSBnbG9iYWxseSB1bmlxdWUuXG4gICovXG4gIHJlYWRvbmx5IGJ1Y2tldE5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG5vdGlmaWNhdGlvbiB0YXJnZXQgY29uZmlndXJhdGlvbnNcbiAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVGFyZ2V0czogYW55O1xuICAvKipcbiAgKiBUaGUgSUQgb2YgdGhlIEdvb2dsZSBDbG91ZCBwcm9qZWN0IHdoZXJlIHRoZSBidWNrZXQgaXMgY3JlYXRlZC5cbiAgKi9cbiAgcmVhZG9ubHkgcHJvamVjdElkOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBJRCBvZiB0aGUgTml0cmljIHN0YWNrXG4gICovXG4gIHJlYWRvbmx5IHN0YWNrSWQ6IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGNsYXNzIG9mIHN0b3JhZ2UgdXNlZCB0byBzdG9yZSB0aGUgYnVja2V0J3MgY29udGVudHMuIFRoaXMgY2FuIGJlIFNUQU5EQVJELCBORUFSTElORSwgQ09MRExJTkUsIEFSQ0hJVkUsIG9yIE1VTFRJX1JFR0lPTkFMLlxuICAqIFNUQU5EQVJEXG4gICovXG4gIHJlYWRvbmx5IHN0b3JhZ2VDbGFzcz86IHN0cmluZztcbn1cbi8qKlxuKiBEZWZpbmVzIGFuIEJ1Y2tldCBiYXNlZCBvbiBhIFRlcnJhZm9ybSBtb2R1bGVcbipcbiogU291cmNlIGF0IC4vLm5pdHJpYy9tb2R1bGVzL2J1Y2tldFxuKi9cbmV4cG9ydCBjbGFzcyBCdWNrZXQgZXh0ZW5kcyBUZXJyYWZvcm1Nb2R1bGUge1xuICBwcml2YXRlIHJlYWRvbmx5IGlucHV0czogeyBbbmFtZTogc3RyaW5nXTogYW55IH0gPSB7IH1cbiAgcHVibGljIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGNvbmZpZzogQnVja2V0Q29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5jb25maWcsXG4gICAgICBzb3VyY2U6ICcuLy5uaXRyaWMvbW9kdWxlcy9idWNrZXQnLFxuICAgIH0pO1xuICAgIHRoaXMuYnVja2V0TG9jYXRpb24gPSBjb25maWcuYnVja2V0TG9jYXRpb247XG4gICAgdGhpcy5idWNrZXROYW1lID0gY29uZmlnLmJ1Y2tldE5hbWU7XG4gICAgdGhpcy5ub3RpZmljYXRpb25UYXJnZXRzID0gY29uZmlnLm5vdGlmaWNhdGlvblRhcmdldHM7XG4gICAgdGhpcy5wcm9qZWN0SWQgPSBjb25maWcucHJvamVjdElkO1xuICAgIHRoaXMuc3RhY2tJZCA9IGNvbmZpZy5zdGFja0lkO1xuICAgIHRoaXMuc3RvcmFnZUNsYXNzID0gY29uZmlnLnN0b3JhZ2VDbGFzcztcbiAgfVxuICBwdWJsaWMgZ2V0IGJ1Y2tldExvY2F0aW9uKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuaW5wdXRzWydidWNrZXRfbG9jYXRpb24nXSBhcyBzdHJpbmc7XG4gIH1cbiAgcHVibGljIHNldCBidWNrZXRMb2NhdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5pbnB1dHNbJ2J1Y2tldF9sb2NhdGlvbiddID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIGdldCBidWNrZXROYW1lKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMuaW5wdXRzWydidWNrZXRfbmFtZSddIGFzIHN0cmluZztcbiAgfVxuICBwdWJsaWMgc2V0IGJ1Y2tldE5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuaW5wdXRzWydidWNrZXRfbmFtZSddID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIGdldCBub3RpZmljYXRpb25UYXJnZXRzKCk6IGFueSB7XG4gICAgcmV0dXJuIHRoaXMuaW5wdXRzWydub3RpZmljYXRpb25fdGFyZ2V0cyddIGFzIGFueTtcbiAgfVxuICBwdWJsaWMgc2V0IG5vdGlmaWNhdGlvblRhcmdldHModmFsdWU6IGFueSkge1xuICAgIHRoaXMuaW5wdXRzWydub3RpZmljYXRpb25fdGFyZ2V0cyddID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIGdldCBwcm9qZWN0SWQoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5pbnB1dHNbJ3Byb2plY3RfaWQnXSBhcyBzdHJpbmc7XG4gIH1cbiAgcHVibGljIHNldCBwcm9qZWN0SWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuaW5wdXRzWydwcm9qZWN0X2lkJ10gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgZ2V0IHN0YWNrSWQoKTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy5pbnB1dHNbJ3N0YWNrX2lkJ10gYXMgc3RyaW5nO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RhY2tJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5pbnB1dHNbJ3N0YWNrX2lkJ10gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgZ2V0IHN0b3JhZ2VDbGFzcygpOiBzdHJpbmcgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLmlucHV0c1snc3RvcmFnZV9jbGFzcyddIGFzIHN0cmluZyB8IHVuZGVmaW5lZDtcbiAgfVxuICBwdWJsaWMgc2V0IHN0b3JhZ2VDbGFzcyh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5pbnB1dHNbJ3N0b3JhZ2VfY2xhc3MnXSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyBnZXQgYnVja2V0TG9jYXRpb25PdXRwdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nKCdidWNrZXRfbG9jYXRpb24nKVxuICB9XG4gIHB1YmxpYyBnZXQgYnVja2V0TmFtZU91dHB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmcoJ2J1Y2tldF9uYW1lJylcbiAgfVxuICBwdWJsaWMgZ2V0IGJ1Y2tldFN0b3JhZ2VDbGFzc091dHB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmcoJ2J1Y2tldF9zdG9yYWdlX2NsYXNzJylcbiAgfVxuICBwcm90ZWN0ZWQgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuaW5wdXRzO1xuICB9XG4gIHByb3RlY3RlZCBzeW50aGVzaXplSGNsQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIE9iamVjdC5mcm9tRW50cmllcyhcbiAgICAgIE9iamVjdC5lbnRyaWVzKHRoaXMuaW5wdXRzKVxuICAgICAgICAuZmlsdGVyKChbLCB2YWxdKSA9PiB2YWwgIT09IHVuZGVmaW5lZClcbiAgICAgICAgLm1hcCgoW2tleSwgdmFsXSkgPT4ge1xuICAgICAgICAgIHJldHVybiBbXG4gICAgICAgICAgICBrZXksXG4gICAgICAgICAgICB7XG4gICAgICAgICAgICAgIHZhbHVlOiB2YWwsXG4gICAgICAgICAgICAgIHR5cGU6IFwiYW55XCIsXG4gICAgICAgICAgICB9LFxuICAgICAgICAgIF07XG4gICAgICAgIH0pXG4gICAgKTtcbiAgfVxufVxuIl19