import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface PolicyConfig extends TerraformModuleUserConfig {
    /**
    * The actions to apply to the policy
    */
    readonly actions: string[];
    /**
    * The IAM roles available to the policy
    */
    readonly iamRoles: any;
    /**
    * The name of the resource
    */
    readonly resourceName: string;
    /**
    * The type of the resource (Bucket, Secret, KeyValueStore, Queue)
    */
    readonly resourceType: string;
    /**
    * The service account to apply the policy to
    */
    readonly serviceAccountEmail: string;
}
/**
* Defines an Policy based on a Terraform module
*
* Source at ./.nitric/modules/policy
*/
export declare class Policy extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: PolicyConfig);
    get actions(): string[];
    set actions(value: string[]);
    get iamRoles(): any;
    set iamRoles(value: any);
    get resourceName(): string;
    set resourceName(value: string);
    get resourceType(): string;
    set resourceType(value: string);
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
