import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
import { Construct } from 'constructs';
export interface HttpProxyConfig extends TerraformModuleUserConfig {
    /**
    * The email of the service account that will invoke the API
    */
    readonly invokerEmail: string;
    /**
    * The name of the HTTP proxy gateway
    */
    readonly name: string;
    /**
    * The ID of the stack
    */
    readonly stackId: string;
    /**
    * The URL of the service being proxied
    */
    readonly targetServiceUrl: string;
}
/**
* Defines an HttpProxy based on a Terraform module
*
* Source at ./.nitric/modules/http_proxy
*/
export declare class HttpProxy extends TerraformModule {
    private readonly inputs;
    constructor(scope: Construct, id: string, config: HttpProxyConfig);
    get invokerEmail(): string;
    set invokerEmail(value: string);
    get name(): string;
    set name(value: string);
    get stackId(): string;
    set stackId(value: string);
    get targetServiceUrl(): string;
    set targetServiceUrl(value: string);
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
