"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vpc = void 0;
// generated by cdktf get
// ./.nitric/modules/vpc
const cdktf_1 = require("cdktf");
/**
* Defines an Vpc based on a Terraform module
*
* Source at ./.nitric/modules/vpc
*/
class Vpc extends cdktf_1.TerraformModule {
    constructor(scope, id, config = {}) {
        super(scope, id, {
            ...config,
            source: './.nitric/modules/vpc',
        });
        this.inputs = {};
        this.cidrBlock = config.cidrBlock;
        this.privateSubnetCidrs = config.privateSubnetCidrs;
        this.publicSubnetCidrs = config.publicSubnetCidrs;
    }
    get cidrBlock() {
        return this.inputs['cidr_block'];
    }
    set cidrBlock(value) {
        this.inputs['cidr_block'] = value;
    }
    get privateSubnetCidrs() {
        return this.inputs['private_subnet_cidrs'];
    }
    set privateSubnetCidrs(value) {
        this.inputs['private_subnet_cidrs'] = value;
    }
    get publicSubnetCidrs() {
        return this.inputs['public_subnet_cidrs'];
    }
    set publicSubnetCidrs(value) {
        this.inputs['public_subnet_cidrs'] = value;
    }
    get privateSubnetIdsOutput() {
        return this.getString('private_subnet_ids');
    }
    get publicSubnetIdsOutput() {
        return this.getString('public_subnet_ids');
    }
    get vpcIdOutput() {
        return this.getString('vpc_id');
    }
    synthesizeAttributes() {
        return this.inputs;
    }
    synthesizeHclAttributes() {
        return Object.fromEntries(Object.entries(this.inputs)
            .filter(([, val]) => val !== undefined)
            .map(([key, val]) => {
            return [
                key,
                {
                    value: val,
                    type: "any",
                },
            ];
        }));
    }
}
exports.Vpc = Vpc;
//# sourceMappingURL=data:application/json;base64,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