const {
  stripScript,
  stripTemplate,
  genInlineComponentText
} = require('./util');
const md = require('./config');

module.exports = function (source) {
  const content = md.render(source);

  const startTag = '<!--ninecat-demo:';
  const startTagLen = startTag.length;
  const endTag = ':ninecat-demo-->';
  const endTagLen = endTag.length;

  let componenetsString = '';
  let id = 0; // demo 的 id
  let output = []; // 输出的内容
  let start = 0; // 字符串开始位置

  let commentStart = content.indexOf(startTag);
  let commentEnd = content.indexOf(endTag, commentStart + startTagLen);
  while (commentStart !== -1 && commentEnd !== -1) {
    output.push(content.slice(start, commentStart));

    const commentContent = content.slice(commentStart + startTagLen, commentEnd);
    const html = stripTemplate(commentContent);
    const script = stripScript(commentContent);
    let demoComponentContent = genInlineComponentText(html, script);
    const demoComponentName = `ninecat-demo${id}`;
    output.push(`<template v-slot:source><${demoComponentName} /></template>`);
    componenetsString += `${JSON.stringify(demoComponentName)}: ${demoComponentContent},`;

    // 重新计算下一次的位置
    id++;
    start = commentEnd + endTagLen;
    commentStart = content.indexOf(startTag, start);
    commentEnd = content.indexOf(endTag, commentStart + startTagLen);
  }

  let pageScript = '';
  if (componenetsString) {
    pageScript = `<script>
      import {
        createTextVNode as _createTextVNode,
        resolveComponent as _resolveComponent,
        withCtx as _withCtx,
        createVNode as _createVNode,
        openBlock as _openBlock,
        createBlock as _createBlock,
        toDisplayString as _toDisplayString ,
        createElementBlock as  _createElementBlock,
        createElementVNode as _createElementVNode,
        normalizeStyle as _normalizeStyle 
      } from "vue"
      export default {
        name: 'component-doc',
        components: {
          ${componenetsString}
        }
      }
    </script>`;
  } else if (content.indexOf('<script>') === 0) {
    start = content.indexOf('</script>') + '</script>'.length;
    pageScript = content.slice(0, start);
  }

  output.push(content.slice(start));

  const res = `
  <template>
    <section>
      ${output.join('')}
    </section>
  </template>
  ${pageScript}
`
  return res;
};