<p align="center">
  <a href="https://ninecat-ui.github.io">
    <a href="https://ninecat-ui.github.io">
    <img width="161" height="125" src="https://upload-images.jianshu.io/upload_images/8108267-b9d5a9dea5e57a79.png?imageMogr2/auto-orient/strip%7CimageView2/2/w/1240" />
  </a>
  </a>
</p>

<h1 align="center">ninecat-ui</h1>

<h3 align="center">A Light Vue 3.0 Web UI Framework</h3>



<div align="center">

[![Build Status](https://travis-ci.com/ninecat-ui/ninecat-ui.svg?branch=master)](https://travis-ci.com/ninecat-ui/ninecat-ui)
[![codecov](https://codecov.io/gh/ninecat-ui/ninecat-ui/branch/master/graph/badge.svg)](https://codecov.io/gh/ninecat-ui/ninecat-ui)
![MIT](https://img.shields.io/badge/license-MIT-000000.svg)
![webpack](https://img.shields.io/badge/webpack-5-blue.svg)
![vue](https://img.shields.io/badge/vue-3.0.2-green.svg)

</div>


<img style="height:100%;width:100%" src="https://github.com/ninecat-ui/ninecat-ui/blob/master/static/Screenshot_en_new.png?raw=true"/>

English | [简体中文](./README-zh_CN.md)


## 📦 Install

Use npm

```bash
npm install ninecat-ui --S
```

Use yarn

```bash
yarn add ninecat-ui
```

## 🔨 Quick Start

```javascript
import { createApp } from 'vue'
import App from './App.vue'
import ninecat from 'ninecat-ui'

const app = createApp(App);
app
  .use(ninecat)
  .mount('#app')

```

## 🖥  Browser Support

Supports all major modern browsers.

| <img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/edge/edge_48x48.png" alt="IE / Edge" width="24px" height="24px" /></br>Edge | <img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/firefox/firefox_48x48.png" alt="Firefox" width="24px" height="24px" /></br>Firefox | <img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/chrome/chrome_48x48.png" alt="Chrome" width="24px" height="24px" /> </br>Chrome | <img src="https://raw.githubusercontent.com/alrra/browser-logos/master/src/safari/safari_48x48.png" alt="Safari" width="24px" height="24px" /></br>Safari |
------------------------------------------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------- |
| >=14                                                                                                                                                  | >= 45                                                                                                                                                         | >=49                                                                                                                                                       | >=10                                                                                                                                                      |


## 🔗 Links

- [Home page](https://ninecat-ui.github.io)
- [Contribution Guide](./.github/CONTRIBUTING.en-US.md)

## ⌨️ Development

Clone locally

```bash
$ git clone https://github.com/ninecat-ui/ninecat-ui.git
$ cd ninecat-ui
$ yarn install
$ yarn start
```

Use Vue3 to refactor component（Doing and need help）

## ✅ Todo List

- [x] Document directory custom configuration.
- [x] Preview demo online.
- [x] Integrate Travis CI.
- [x] Integrate codecov.
- [x] Building documents automatically. 
- [x] Tag to build npm packages automatically.
- [x] Component unit testing. 
- [x] Integrate docsearch.(Some problems,need fix.)
- [x] Support JSX.
- [ ] Common component develop.(Doing)
- [ ] Integrate codepen.
- [ ] Color theme customization.
- [ ] Globalization.
- [x] Mixed develop with typescript and JavaScript.
- [x] Use Vue3 to refactor component（Doing and need help）.

## 🤝 Join Discussion Group

Scan the QR code using [QQ](https://im.qq.com/) to join in discussion group

<img alter="Discussion Group" src="https://github.com/ninecat-ui/ninecat-ui/blob/master/static/share.JPG?raw=true" width="250px" >
