# Contributing to Pantha

Firstly, I would like to thank you for taking interest in contributing to Pantha. 👍
**All contributions must follow our code of conduct ([here](https://github.com/nigamanthsrivatsan/Pantha))**

## How to contribute?
Sections:

* Reporting bugs
* Suggesting improvements 
* Changing configuration 
* Editing documentation 

### Reporting a bug

Pantha is a fairly big discord bot and therefore may have some bugs, if you are sure that you have encountered an error in Pantha, then you can open an issue on the same.

Please ensure that:

* you give **as much detail as possible**
* search for issues before submitting your issue (I could be working on the issue)
* include the complete traceback so we can tell what the clear problem is
* how to reproduce the issue you have encountered
* what is expected to happen, and what happened instead

### Suggesting improvements

Pantha needs your suggestions and inputs on how to evolve and become more efficient. If you have a suggestion in mind, you can feel free to open a pull request or an issue on the same 

Please ensure that:

* You're only changing what you need to
* Is it improving on a feature? Why is it needed?
* What help will it do to the bot?
* Does the new feature work with the bot? 
* Give as much inforation as possible

### Changing configuration

I have programmed this discord bot for months, and this was originally for my server, so there's a chance that you can make the configuration easier.

Feel free to open a pull request or an issue, however I cannot guarantee that I will make it easier to self-host. 

### Editing documentation

We do not have documentation right now, the bot is easy enough to understand and set up. 

## Extra:

Please define types in your python code, and try to have it annotated to make it more clear.
