% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_ai.R
\name{scrape_ai}
\alias{scrape_ai}
\title{Scrape data from a website using AI}
\usage{
scrape_ai(
  url,
  prompt = "Summarise the following: ",
  prompt_system = "You can only respond with a pipe-separated table.",
  cols,
  clean = "text",
  css = FALSE,
  xpath = FALSE,
  ...
)
}
\arguments{
\item{url}{A URL to the page you want to scrape.}

\item{prompt}{A question you want to ask GPT. Something like "Summarise this as a table".}

\item{prompt_system}{The system message helps set the behaviour of the AI. It can be something like "You are a helpful assistant."}

\item{cols}{The columns of the tibble to be returned. Could be something like `c("State", "Area", "Population")`}

\item{clean}{Whether to strip the HTML of unnecessary tags to reduce the number of tokens. Can be set to `"text"`, `"html"` or `FALSE`.}

\item{css}{CSS selector (also to reduce the number of tokens).}

\item{xpath}{XPATH selector (also to reduce the number of tokens). Alternative to the CSS selector.}
}
\description{
You will need an OpenAI API key.
}
\examples{
oscar_winners <- scrape_ai("https://edition.cnn.com/2023/03/12/entertainment/oscar-winners-2023/index.html", cols = c("category", "winner", "nominees"), clean = "text", css = "div[itemprop='articleBody']")
}
