% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_ai.R
\name{extract_ai}
\alias{extract_ai}
\title{Parse a string or vector to a tibble}
\usage{
extract_ai(
  text,
  prompt = "Summarise the following: ",
  prompt_system = "You can only respond with a pipe-separated table.",
  cols,
  ...
)
}
\arguments{
\item{text}{A vector of unstructured text you want to parse to a table.}

\item{prompt}{A question you want to ask GPT. Something like "Summarise this as a table".}

\item{prompt_system}{The system message helps set the behaviour of the AI. It can be something like "You are a helpful assistant."}

\item{cols}{The columns of the tibble to be returned. Could be something like `c("State", "Area", "Population")`}
}
\description{
You will need an OpenAI API key.
}
\examples{
mps <- readr::read_csv("https://raw.githubusercontent.com/sparkd/mp-financial-interests/master/data/financial-interests-2010-18.csv") |>
  dplyr::filter(type_code == 1) |>
  head(100) |>
  purrr::pluck("description") |>
  extract_ai(cols = c("date", "sum", "donor", "donor_address", "purpose", "hours", "date_registered"))
}
