% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/answer_ai.R
\name{answer_ai}
\alias{answer_ai}
\title{Send a prompt to GPT and get a response}
\usage{
answer_ai(
  prompt,
  prompt_system =
    "You are a helpful assistant that answers question as briefly as possible.",
  ...
)
}
\arguments{
\item{prompt}{A question you want to ask GPT.}

\item{prompt_system}{The system message helps set the behaviour of the AI. It can be something like "You are a helpful assistant."}
}
\description{
You will need an OpenAI API key.
}
\examples{
top_banks <- tibble::tribble(~bank, "HSBC Holdings", "Lloyds Banking Group", "Royal Bank of Scotland Group", "Barclays", "Standard Chartered", "Santander UK", "Nationwide Building Society", "Schroders") |>
    dplyr::mutate(website = answer_ai(paste0("Official website of ", bank, ": ")),
                  phone_nr = answer_ai(paste0("Customer service number of ", bank, ": ")))
}
